/*******************************************************************
*  MINARET (for edge-triggered circuits)
*
*  BY
*
*  NARESH MAHESHWARI AND SACHIN S. SAPATNEKAR
*
*  Copyright 1998 Iowa State University Research Foundation, Inc.
*  All Rights Reserved
*
*  Source Code for retiming edge-triggered circuits
*
*  ASTRA:   Refer to paper in DAC 95 by Deokar & Sapatnekar
*                       and IEEE Tran on CAD 10/1998
*  Minaret: Refer to paper in DAC 97 by Maheshwari & Sapatnekar
*                       and IEEE Tran on VLSI 10/1998
*
*  Contact Address: sachin@ece.umn.edu
*
*        Availiable on as is basis, with no support
*******************************************************************/
/*******************************
FILE common_utils.h

List of common utilities used by many files
******************************/


void printq();
void print_levels();
void print_graph();
void print_pos_edges();
void print_skews();
void print_node(int);
void print_ckt();
void print_latches();
void print_freenodes();
void print_validnodes();
void print_ckt_graph();
void print_modified_graph(int);
void print_reverse_modified_graph(int);

/*******************************
FILE util.c
misc utility functions 
for Q etc
******************************/

void init_ckt_stuff(); /* to set  vars */

void createq(int);/* for Q */
void addq(int);
void removeq();
Q *deleteq(Q *,int);

void free_graph();
void min_max_skew();
void set_delays(); /* to set non unit delays */
void free_list(Q *);
void free_F(F *);
void reset_ckt();
void free_all_latches();
void check_connection();
void check_latches_mult(int);

Q *copyq( Q *);
F *copyF( F *);
F *copy_reverse_F(F *);


/*********EOF**********/
