/*******************************************************************
*  MINARET (for edge-triggered circuits)
*
*  BY
*
*  NARESH MAHESHWARI AND SACHIN S. SAPATNEKAR
*
*  Copyright 1998 Iowa State University Research Foundation, Inc.
*  All Rights Reserved
*
*  Source Code for retiming edge-triggered circuits
*
*  ASTRA:   Refer to paper in DAC 95 by Deokar & Sapatnekar
*                       and IEEE Tran on CAD 10/1998
*  Minaret: Refer to paper in DAC 97 by Maheshwari & Sapatnekar
*                       and IEEE Tran on VLSI 10/1998
*
*  Contact Address: sachin@ece.umn.edu
*
*        Availiable on as is basis, with no support
*******************************************************************/
/************************************
function.h

contains list of all functions for minarea retiming
******************************************/

#ifndef DEFINE_FN_PROTO  /* just to make sure declared only once */
#define DEFINE_FN_PROTO

/**************************************
bell.c
*************************/

float bellford(float cur_p,float init_value,int Graph_Dir);
void normalise_skews(int Graph_Dir,int skew_mode);
float opt_period();

/**************************************
bounds.c
*************************/

int get_bounds(float period);

/**************************************
cnvt.c
*************************/

void ckt2graph();
void clear_ckt_graph();
void free_saved_latches();
void graph2ckt();
void print_saved_latches();
void proc_fin(int n);
void remove_pio();
void restore_ckt_graph(int index);
void restore_pio();
void restore_skews(int index);
void set_up_retime_Q();
void update_skews_with_slack_for_reverse_retiming(int index, float period);
int add_merged_latches_at_fanout(int in);
void graph2mergedckt();

/**************************************
graph.c
*************************/

void add_edge(int from,int to,float delay);
void check_connect_graph(int Dir);
void complete_graph();
void init_graph();
void make_reverse_graph();

/**************************************
hash.c
*************************/

void destroy_hash();
void disposeof(struct pn *n);
int init_node(int k, char *name);
void  inithash();
void inshash(struct pn *nd);
int keyfor(char *a);
void newnode(struct hashnode *n);
int searchhash(char *look,int PiPo);
void splithashnode();

/**************************************
heap.c
*************************/

void free_heaps();
INT_FLT get_max(int index);
int get_min_index();
void heap_insert(int index, float value, int id);
void heapify(int index,int element);
void init_heaps(int max_no_of_heaps, int max);
void print_heap(int index);
void reset_heaps();

/**************************************
io.c
*************************/

void write_benchmark(FILE *fpw);
void write_latches(FILE *fpw);
void write_netlist(FILE *fpw);

/**************************************
latch_utils.c
*************************/

int add_latch(int in,int out,float skew,char *name);
int add_latch_at_fanout(int in,float skew,char *name);
void check_latches_mult(int mode);
int make_single_fanout(int mode);
int multiply_latch(int n);
float remove_latch(int n);
int update_nai_at_output(int n);
int update_nao_at_input(int n);


/**************************************
pert.c
*************************/

void all_pert();
void find_levels();
void process_input(int in_no);

/**************************************
phase2.c
*************************/

int retime(float period,int slack_for , int slack_rev ,int bound_dir,int do_period);
void retime_gate_inputs(int n,int use_slack_mode,int bound_dir,int do_period);
void retime_gate_outputs(int n,int use_slack_mode,int bound_dir,int do_period);

/**************************************
postproc.c
*************************/

void merge_latches();
int merge_latches_at_output(int n);
int merge_latches_at_output_without_skew(int n);

/**************************************
print.c
*************************/

void print_ckt();
void print_ckt_graph();
void print_freenodes();
void print_graph();
void print_latches();
void print_levels();
void print_modified_graph(int mode);
void print_node(int n);
void print_pos_edges();
void print_reverse_modified_graph(int mode);
void print_skews();
void print_validnodes();
void printq();

/**************************************
retime.c
*************************/

int add_art_at_input();
int add_latches_in_cycles();
void apply_retiming();
void check_merging_of_latches();
int count_latches_in_graph();
void print_2_cycles();
void store_moves();

/**************************************
simplex.c
*************************/

void check_nodes_S_Arcs();
Q *delete_child(Q *list,int child);
int find_cycle(int P, int q, int *tree, int *K, int *U, int *V);
int get_entering_arc();
int get_max_cost_in_simplex();
void make_simplex_tree(int Red_Mode);
void print_S_Arcs();
void print_S_nodes();
int read_simplex( int Red_Mode);
int  solve_simplex();
void start_simplex_network( int Red_Mode);
void update_dual_and_level(int P,int q,int V,int ch);
void update_stem(int P, int q,int U, int V, int flow, int orient);

/**************************************
slack.c
*************************/

float forwardpert(int mode);
float reversepert(int mode);
int use_slacks(float period);

/**************************************
utils.c
*************************/

#ifdef SAFE
void *CALLOC(size_t nelem, size_t elsize);
void *MALLOC(size_t nelem, size_t elsize);
#else

#define CALLOC(a,b) calloc(a,b)
#ifdef MAL2CAL
#define MALLOC(a,b) calloc(a,b)
#else
#define MALLOC(a,b) malloc((a)*(b))
#endif

#endif

W * Sdelete_W(W *fout,int n);
void addq(int k);
void check_connection();
void check_levels();
void check_nodeid();
F * copy_F(F *orignal);
Q * copy_Q(Q *orignal);
W * copy_W(W *orignal);
F * copy_reverse_F(F *orignal);
int count_latch_fout();
void createq(int k);
Q *delete_Q(Q *fout,int n);
W *delete_W(W *fout,int n);
void free_F(F *list);
void free_Q(Q *list);
void free_W(W *list);
void free_all_latches();
void free_ckt();
void free_graph();
void init_ckt_stuff();
void min_max_skew();
void remove_artificial_gates();
void removeq();
void reset_ckt();
void set_delays(float);

/**************************************
wd.c
*************************/

void  generate_period_cons(float clk,int Red_Mode,int Max_W);
void get_wd_row(int w, float clock, int Reduce_Mode);


#endif
