/*******************************************************************
*  MINARET (for edge-triggered circuits)
*
*  BY
*
*  NARESH MAHESHWARI AND SACHIN S. SAPATNEKAR
*
*  Copyright 1998 Iowa State University Research Foundation, Inc.
*  All Rights Reserved
*
*  Source Code for retiming edge-triggered circuits
*
*  ASTRA:   Refer to paper in DAC 95 by Deokar & Sapatnekar
*                       and IEEE Tran on CAD 10/1998
*  Minaret: Refer to paper in DAC 97 by Maheshwari & Sapatnekar
*                       and IEEE Tran on VLSI 10/1998
*
*  Contact Address: sachin@ece.umn.edu
*
*        Availiable on as is basis, with no support
*******************************************************************/
/***************************************
FILE include.h

contains the include commands for all files;
all files will just include "include.h"
***********************************************/

#include<stdio.h>
#include<malloc.h>
#include<string.h>
#include <stdlib.h>

#include "declare.h"
#include "type.h"
#include "var.h"
#include "functions.h"

/***********************************************

These constants when defined enable portions of code, mainly useful for debugging
they are:

 DEBUG : Enables priniting of debug print statements (which are controlled by 
         db_* variables in main.h).
 STATS : Enables some statistical data collection.

 MY_METHOD : Improves the performance by removing some "if(Red_Mode == REDUCE)" checks
 SAFE  : Enables code operation in a safe but slow mode,
         i.e., the code becomes "nice" checking memory availiablity etc 
 CHECK : Perform some simple checks on the data structure
         e.g., fanin/fanout connections are bidirection
 MAL2CAL:  MALLOC converted to CALLOC (so that all memory is initialized)
 
#define CHECK
#define SAFE
#define DEBUG
#define STATS
#define MY_METHOD
***********************************************/
/*********EOF**********/
