/*******************************************************************
*  MINARET (for edge-triggered circuits)
*
*  BY
*
*  NARESH MAHESHWARI AND SACHIN S. SAPATNEKAR
*
*  Copyright 1998 Iowa State University Research Foundation, Inc.
*  All Rights Reserved
*
*  Source Code for retiming edge-triggered circuits
*
*  ASTRA:   Refer to paper in DAC 95 by Deokar & Sapatnekar
*                       and IEEE Tran on CAD 10/1998
*  Minaret: Refer to paper in DAC 97 by Maheshwari & Sapatnekar
*                       and IEEE Tran on VLSI 10/1998
*
*  Contact Address: sachin@ece.umn.edu
*
*        Availiable on as is basis, with no support
*******************************************************************/
/*******************************
FILE latch_utils.c
utility to add/delete/multiply latches etc
Not in much use now (after converting to the 
C-graph format)
******************************/

#include "include.h"


/*******************************
EXTERNAL VARS
******************************/

extern int db_ret;
extern int db_ret1;
extern int Latch_Remove_Counter;
extern int Latch_Add_Counter;

/************************************

remove the latch "n"

   removes latch and updates fanin/fanout;
   maintains the invalid gatelists in invalid[],
   and the # of invalid nodes in noinvalid,
   also adjusts nonodes
*********************************************************/
float remove_latch(int n)
{
  NODETYPE *np, *inpt;
  W *w1, *w2, *w3;
  float rem_skew;
  int in;

  np = nodes[n];
  if(np->type != Latch){
    printf("\n ERR{remove_latch} [%d]%s is not a latch\n",n,np->name);
    exit(0);
  }

  rem_skew = np->skew;
  in = (np->fin)->el;
  free(np->fin);
  inpt = nodes[in];
  for(w1=np->fout;w1 != NULL; w1= w1->next)
    {
      /* correct the fanin of fanouts of latch */
      w2=nodes[w1->el]->fin;
      while(w2 != NULL)
	{
	  if(w2->el == n)w2->el = in;
	  w2= w2->next;
	}
    }

  inpt->fout = delete_W(inpt->fout,n);

  /* delete this latch from fanout*/

  if(inpt->fout != NULL)
    {
      for(w3=inpt->fout;w3->next!= NULL; w3= w3->next);
      w3->next = np->fout;
    }
  else inpt->fout = np->fout;
  inpt->nofout += (np->nofout -1);

  /***************************************************
    don't copy the fanout of latch, just appends it to input's fanout 
    mark invalid, DON'T free the latch's  memory space, as add latch will use the same space. 
    np->fout is appended to that of the input gate so do not free it. 
    ***************************************************/

  if(n == maxid-1)maxid--;
  else freenodes[++nofreenodes] = n;
  validnode[n] = 0;
  change--;
  nolatches--;
  nonodes--;
	
  free(np);


  latches = delete_Q(latches,n);
  Latch_Remove_Counter++;
  return(rem_skew);
}


/**************************************************
add_latch(int in,int out,float skew,char *name)

adds a latch between two nodes:  in--> latch -->out
with skew "skew" and returns the id of the added latch

changed on 3/17 so that it deallocates and reallocates mem
*****************************************************/

int add_latch(int in,int out,float skew,char *name)
{
  int n,i,done;
  NODETYPE *np,*inp,*outp;
  Q *q1;
  W *w1,*w2;

  inp = nodes[in];
  outp = nodes[out];

  if(nofreenodes >0) /* a freed node availiable */
    {
      n = freenodes[nofreenodes--];
      if(validnode[n] !=0){
	printf("\n ERR{add_latch} overwriting node %d nofreenodes %d and are\n\n",n,nofreenodes);
	for(i=0;i<nofreenodes;i++)printf(" %d ",freenodes[i]);
	exit(0);
      }

      if(db_ret1){
	printf(" using freed node %d ",n);
	print_freenodes();
      }
    }
  else 
    {
      n =maxid++;
    }


  np = (NODETYPE *)CALLOC(1,sizeof(NODETYPE));
  nodes[n] = np;
  validnode[n] = 1;


  strcpy(np->name,name);

	
  done = 0;
  for(w1=inp->fout;w1 != NULL; w1= w1->next)
    {
      if(w1->el == out)
	{
	  w1->el = n;
	  done = 1;
	  break;
	  /**** !!!! change only one or all */
	}
    }
  if(!done){
    printf("\n ERR{add_latch} did not find [%d]%s in fout of [%d]%s\n",out,outp->name,in,inp->name);
    exit(0);
  }

  done = 0;
  for(w1=outp->fin;w1 != NULL; w1= w1->next)
    {
      if(w1->el == in)
	{
	  w1->el = n;
	  done = 1;
	  break;
	  /**** !!!! change only one or all */
	}
    }
  if(!done) {
    printf("\n ERR{add_latch} did not find [%d]%s in IN of [%d]%s\n",in,inp->name,out,outp->name);
    exit(0);
  }


  /* update the added latch */
  np->id = n;
  np->type = Latch;
  np->nofin = 1;
  w1= (W *)MALLOC(1,sizeof(W));
  w1->el = in;
  w1->next = NULL;
  w1->list = NULL;
  np->fin = w1;
  np->nofout = 1;
  w1= (W *)MALLOC(1,sizeof(W));
  w1->el = out;
  w1->next = NULL;
  w1->list = NULL;
  np->fout = w1;

  np->skew = skew;
  np->phase = -1;
  np->level = -INF;
  np->nai = 0;
  np->mindel = 0;
  np->maxdel = 0;
  np->minto =INF;
  np->minti = INF;
  change++;
  nonodes++;
  nolatches++;
  q1= (Q *)MALLOC(1,sizeof(Q));
  q1->el = n;
  q1->next = latches;
  latches = q1;
#ifdef DEBUG
  if(db_ret)printf(" added latch [%d]%s between [%d]%s and [%d]%s skew %g\n",n,name,in,inp->name,out,outp->name,skew);
#endif
  Latch_Add_Counter++;
  return(n);

}

/*********************************************************
multiply_latch(int n)

multiply the given latch "n" so that each copy has only
one fanout while preserving skew 
*************************************************/

int multiply_latch(int n)
{
  NODETYPE *np,*np1;
  W *w1;
  int *fanlist;
  int i,t,foutno,in,n1;
  float skew,slack,rev_maxti;
  int add_count=0;
  char name[200];

  np = nodes[n];
  strcpy(name,np->name);
  if(np->type != Latch){
    printf(" \n ERR{multiply_latch} [%d]%s given to make single fanout type %d",n,np->name,np->type);
    exit(0);
  }

  in = (np->fin)->el;
  /* save fanouts of the latch in a array */
  fanlist = (int *)MALLOC((np->nofout+1),sizeof(int));
	
  foutno = 0;
  for(w1=np->fout;w1 != NULL; w1= w1->next)
    {
      fanlist[foutno++] = w1->el;
    }
  if(foutno != (np->nofout)){
    printf("ERR {mult_latch} latch [%d]%s has %d fanout but only %d copied in fanout list \n",n,np->name,np->nofout,
	   foutno);
    exit(0);
  }
  rev_maxti = np->rev_maxti;
  skew = remove_latch(n);

#ifdef DEBUG
  if(0){
    print_node(in);
    printf("Latches to add %d at ",foutno);
    for(i=0;i<foutno;i++)printf(" [%d]%s ",fanlist[i],nodes[fanlist[i]]->name);
    printf("\n");
  }
#endif
  /* add latches to all original fanouts */
  for(i=0;i<foutno;i++)
    {
      n1 = fanlist[i];

      /**
	np1 = nodes[n1];
	slack = rev_maxti - np1->rev_maxto;
	if(skew < 0)
	{skew = skew + slack;
	if(skew >0)skew = 0;
	}
	*******************/
      t = add_latch(in,n1,skew,name);
      add_count++;
    }

  free(fanlist);
  return(add_count);
}

/*********************************************************
add_latch_at_fanout(int in,float skew,char *name)

add a latch at fanout of gate "in" with "skew" and return id
*********************************************************/

int add_latch_at_fanout(int in,float skew,char *name)
{
  int n,done;
  NODETYPE *np,*inp, *outp;
  W *w1,*w2;
  Q *q1;
	
  inp = nodes[in];

  if(nofreenodes >0) /* a freed node availiable */
    {
      n = freenodes[nofreenodes--];
      np = nodes[n];
      if(validnode[n] !=0)
	{
	  printf("\n ERR{add_latch_at_fanout} overwriting node %d\n\n",n);
	  exit(0);
	}
		
    }
  else 
    {
      n = maxid++;
    }

  np = (NODETYPE *)CALLOC(1,sizeof(NODETYPE));
  nodes[n] = np;
  validnode[n] = 1;
  strcpy(nodes[n]->name,name);

	
  done = 0;
  for(w1=inp->fout;w1 != NULL; w1= w1->next)
    {
      outp = nodes[w1->el];
      for(w2=outp->fin;w2 != NULL; w2= w2->next)
	{
	  if(w2->el == in){
	    w2->el = n;
	    done = 1;
	  }
	}
      if(!done){
	printf("\n ERR{add_latch_at_fanout} did not find %d in OUT of %d\n",in,w1->el);
	exit(0);
      }
    }

  /* update the added latch */
  np->id = n;
  np->type = Latch;
  np->nofin = 1;
  w1= (W *)MALLOC(1,sizeof(W));
  w1->el = in;
  w1->next = NULL;
  w1->list = NULL;
  np->fin = w1;

  np->fout = inp->fout;
  np->nofout = inp->nofout;

  np->skew = skew;
  np->phase = -1;
  np->level = -INF;
  np->nai = 0;
  np->nao = 0;
  np->mindel = 0;
  np->maxdel = 0;
  np->minti = INF;
  np->minti = INF;

  /* update fanout of in */
  inp->nofout = 1;
  w1= (W *)MALLOC(1,sizeof(W));
  w1->el = n;
  w1->next = NULL;
  w1->list = NULL;
  inp->fout = w1;

  change++;
  nonodes++;
  nolatches++;
  q1= (Q *)MALLOC(1,sizeof(Q));
  q1->el = n;
  q1->next = latches;
  latches = q1;
  return(n);

}

/**************************************************
update_nai_at_output(int n)

increases "nai" of all gates (not latches) at fanouts of "n"
and adds it to queue if(nai == nfin)
returns 1, if anything added to queue
****************************************************/
int update_nai_at_output(int n)
{
  NODETYPE *np, *np1;
  int n1,no=0;
  W *w1;

  np = nodes[n];
	
  for(w1=np->fout;w1 != NULL;w1 = w1->next)
    {
      n1 = w1->el;
      np1 = nodes[n1];
      /*printf(" %d[%s] latch fout %d[%s]\n",n,np->name,n1,np1->name);*/
      if(np1->type != Latch)
	{
	  if(++(np1->nai) == np1->nofin){
	    addq(n1);
	    no = 1;
	  }
	}

    }
  return(no);
}


/*********************************************
update_nao_at_input(int n)

increases "nao" of all gates (not latches) at fanins of "n"
and adds it to queue if(nao == nfout)
returns 1, if anything added to queue

**********************************************/
int update_nao_at_input(int n)
{
  NODETYPE *np, *np1;
  int n1,no=0;
  W *w1;

  np = nodes[n];
	
  for(w1=np->fin;w1 != NULL;w1 = w1->next)
    {
      n1 = w1->el;
      np1 = nodes[n1];
      /*printf(" %d[%s] latch FIN %d[%s]\n",n,np->name,n1,np1->name);*/
      if(np1->type != Latch)
	{
	  if(++(np1->nao) == np1->nofout){
	    addq(n1);
	    no = 1;
	  }
	}
    }
  return(no);
}

/***********************************************
make_single_fanout(int mode)

Makes all latches have single fanout;
calls multiply_latch for each latch.
Returns number of latches added.
If mode == 0 then only latches with negative skews
are multiplied 

Since multiply latch changes the linked list "latches"
It saves all latches in need of multiplication
and then multiplies them.
Also checks if the correct number of latches were added
*********************************************************/
int make_single_fanout(int mode)
{
  Q *qt,*q1,*temp_latches;
  NODETYPE *np;
  int init_no,to_mult,added=0,done=0,fanout_was,total_added=0,loop_added=0,loop_c=0,loop_init_no;

  db_ret1 = 0;
  init_no = nolatches;

  done =0;
  while(!done)
    {
      temp_latches = NULL;
      to_mult =0;
      done = 1;
      loop_c++;
      loop_init_no = nolatches;
      for(q1= latches;q1 != NULL;q1= q1->next)
	{
	  np = nodes[q1->el];
	  if((np->nofout >1)&& ((np->skew < 0)||mode))
	    {
	      qt = (Q *)MALLOC(1,sizeof(Q));
	      qt->el = q1->el;
	      qt->next = temp_latches;
	      temp_latches = qt;
	      to_mult += np->nofout -1;
	      done = 0;
	    }
	}
      loop_added =0;
      for(q1= temp_latches;q1 != NULL;q1= q1->next)
	{
	  fanout_was = nodes[q1->el]->nofout;
	  added = multiply_latch(q1->el);
	  loop_added = loop_added + added -1;
	  if(fanout_was != added){
	    printf("\n ERR { make_single_fanout} for deleted latch [%d] fanout was %d but only %d latches added\n",q1->el,fanout_was,added);
	    exit(0);
	  }
	}

      if(loop_added != (nolatches - loop_init_no))printf("\n ERR { make_single_fanout} loop %d added %d but latch no moved from %d to %d \n",loop_c,loop_added,loop_init_no,nolatches);
      total_added += loop_added;
    }/* while !done */


  /*****printf(" total loops done %d added latches %d init %d now %d\n",loop_c,total_added,init_no,nolatches);
        
    printf("\n  make_single_fanout init latches %d final %d but %d where to be added \n",init_no,nolatches,to_mult);
    if((nolatches - init_no)!= to_mult){printf("\n ERR in make_single_fanout init latches %d final %d but %d where to be added \n",init_no,nolatches,to_mult);exit(0);}*****/


  free_Q(temp_latches);
  return(total_added);

}

/*********************************************
checks that all latches have only one fanout.
******************************************/
void check_latches_mult(int mode)
{
  Q *q1;
  W *w2,*w3;
  NODETYPE *np,*np1;
  int n,n1,done;

  for(q1= latches;q1 != NULL;q1= q1->next)
    { 
      n = q1->el;
      if(!validnode[n])printf("ERR not valid node %d in latch list \n",n);
      else
	{ 
	  n - q1->el;
	  np = nodes[n];
	  if(np->type != Latch){
	    printf("ERR NON latch [%d]%s type %d in latch list\n",n,np->name,np->type);
	    exit(0);
	  }
	  if((np->nofout >1)&& ((np->skew < 0)||mode))
	    {
	      printf("ERR latch [%d]%s has %d fout\n",n,np->name,np->nofout);
	      exit(0);
	    }
	  for(w2=np->fout;w2 != NULL; w2= w2->next)
	    {
	      n1 = w2->el;
	      if(!validnode[n1])printf("ERR not valid node %d in fanout of [%d]%s \n",n1,n,np->name);
	      else
		{
		  np1 = nodes[w2->el];
		  done = 0;
		  for(w3=np1->fin;w3 != NULL; w3= w3->next)
		    { 
		      if(w3->el == n)done=1;
		    }
		  if(!done){
		    printf("ERR  %d[%s]'s fanout  [%d]%s does not have it in its fanin\n",n,np->name,
			   n1,np1->name);
		    exit(0);
		  }
		}
	    }
	  for(w2=np->fin;w2 != NULL; w2= w2->next)
	    {
	      n1 = w2->el;
	      if(!validnode[n1])printf("ERR not valid node %d in fanin of [%d]%s \n",n1,n,np->name);
	      else
		{
		  np1 = nodes[w2->el];
		  done = 0;
		  for(w3=np1->fout;w3 != NULL; w3= w3->next)
		    { 
		      if(w3->el == n)done=1;
		    }
		  if(!done){
		    printf("ERR  %d[%s]'s fanin  [%d]%s does not have it in its fanout\n",n,np->name,
			   n1,np1->name);
		    exit(0);
		  }
		}
	    }

	}
    }/* for all latches */
}


/*********EOF**********/
