/*******************************************************************
*  MINARET (for edge-triggered circuits)
*
*  BY
*
*  NARESH MAHESHWARI AND SACHIN S. SAPATNEKAR
*
*  Copyright 1998 Iowa State University Research Foundation, Inc.
*  All Rights Reserved
*  Source Code for retiming edge-triggered circuits
*
*  ASTRA:   Refer to paper in DAC 95 by Deokar & Sapatnekar
*                       and IEEE Tran on CAD 10/1998
*  Minaret: Refer to paper in DAC 97 by Maheshwari & Sapatnekar
*                       and IEEE Tran on VLSI 10/1998
*
*  Contact Address: sachin@ece.umn.edu
*
*        Availiable on as is basis, with no support
*******************************************************************/
/*******************************
FILE  lex.l

Lex grammer for retiming of edge-triggered circuits, in the 
modified MCNC format

*****************************/
#define LEXDEBUG
/* DECMAL	[-\+]*[0-9]+\.[0-9]+ */

%{
#include "y.tab.h"
#include <stdlib.h>  /** needed for "atof" **/
#include "include.h"

int	numbertoken			; 
char	*nametoken			; 
char lastconn[MAX_NAME]			; /* to copy the last connection
name read in				; to be used in yacc.y */
extern double init_delay		;

%}

%%

\*.*\n*					;

"DFF"		return(DFF)		;
"dff"		return(DFF)		;
"NOT"		return(NOT)		;
"not"		return(NOT)		;
"NOR"		return(NOR)		;
"nor"		return(NOR)		;
"NAND"		return(NAND)		;
"nand"		return(NAND)		;
"AND"		return(AND)		;
"and"		return(AND)		;
"OR"		return(OR)		;
"or"		return(OR)		;
"INPUT"		return(INPUT)		;
"input"		return(INPUT)		;
"OUTPUT"	return OUTPUT		;
"output"		return(OUTPUT)	;
[A-Za-z0-9_\.#\/\(\)\$:]+  	 {strcpy(lastconn, yytext) ;return(CONN);}
[@][0-9.]+       {init_delay = atof(&yytext[1])	;return(IDEL);}


\n+		return(NEWLINE)		; 

[ \t]					; 	/* skip white space */ 
.		return yytext[0]	;
%% 
