/******************************************************************
*  MINARET (for edge-triggered circuits)
*
*  BY
*
*  NARESH MAHESHWARI AND SACHIN S. SAPATNEKAR
*
*  Copyright 1998 Iowa State University Research Foundation, Inc.
*  All Rights Reserved
*
******************************************************************/
#include <stdio.h>
# define U(x) x
# define NLSTATE yyprevious=YYNEWLINE
# define BEGIN yybgin = yysvec + 1 +
# define INITIAL 0
# define YYLERR yysvec
# define YYSTATE (yyestate-yysvec-1)
# define YYOPTIM 1
# define YYLMAX BUFSIZ
#ifndef __cplusplus
# define output(c) (void)putc(c,yyout)
#else
# define lex_output(c) (void)putc(c,yyout)
#endif

#if defined(__cplusplus) || defined(__STDC__)

#if defined(__cplusplus) && defined(__EXTERN_C__)
extern "C" {
#endif
	int yyback(int *, int);
	int yyinput(void);
	int yylook(void);
	void yyoutput(int);
	int yyracc(int);
	int yyreject(void);
	void yyunput(int);
	int yylex(void);
#ifdef YYLEX_E
	void yywoutput(wchar_t);
	wchar_t yywinput(void);
#endif
#ifndef yyless
	int yyless(int);
#endif
#ifndef yywrap
	int yywrap(void);
#endif
#ifdef LEXDEBUG
	void allprint(char);
	void sprint(char *);
#endif
#if defined(__cplusplus) && defined(__EXTERN_C__)
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
	void exit(int);
#ifdef __cplusplus
}
#endif

#endif
# define unput(c) {yytchar= (c);if(yytchar=='\n')yylineno--;*yysptr++=yytchar;}
# define yymore() (yymorfg=1)
#ifndef __cplusplus
# define input() (((yytchar=yysptr>yysbuf?U(*--yysptr):getc(yyin))==10?(yylineno++,yytchar):yytchar)==EOF?0:yytchar)
#else
# define lex_input() (((yytchar=yysptr>yysbuf?U(*--yysptr):getc(yyin))==10?(yylineno++,yytchar):yytchar)==EOF?0:yytchar)
#endif
#define ECHO fprintf(yyout, "%s",yytext)
# define REJECT { nstr = yyreject(); goto yyfussy;}
int yyleng;
char yytext[YYLMAX];
int yymorfg;
extern char *yysptr, yysbuf[];
int yytchar;
FILE *yyin = {stdin}, *yyout = {stdout};
extern int yylineno;
struct yysvf { 
	struct yywork *yystoff;
	struct yysvf *yyother;
	int *yystops;};
struct yysvf *yyestate;
extern struct yysvf yysvec[], *yybgin;

# line 2 "lex.l"
/*******************************************************************
*  MINARET (for edge-triggered circuits)
*
*  BY
*
*  NARESH MAHESHWARI AND SACHIN S. SAPATNEKAR
*
*  Copyright 1998 Iowa State University Research Foundation, Inc.
*  All Rights Reserved
*
*  Source Code for retiming edge-triggered circuits
*
*  ASTRA:   Refer to paper in DAC 95 by Deokar & Sapatnekar
*                       and IEEE Tran on CAD 10/1998
*  Minaret: Refer to paper in DAC 97 by Maheshwari & Sapatnekar
*                       and IEEE Tran on VLSI 10/1998
*
*  Contact Address: sachin@ece.umn.edu
*
*        Availiable on as is basis, with no support
*******************************************************************/

# line 16 "lex.l"
/*******************************
FILE  lex.l

Lex grammer for retiming of edge-triggered circuits, in the 
modified MCNC format

*****************************/

# line 24 "lex.l"
/* DECMAL	[-\+]*[0-9]+\.[0-9]+ */
#include "y.tab.h"
#include <stdlib.h>  /** needed for "atof" **/
#include "include.h"

int	numbertoken			;
char	*nametoken			;
char lastconn[MAX_NAME]			; /* to copy the last connection
name read in				; to be used in yacc.y */
extern double init_delay		;

# define YYNEWLINE 10
yylex(){
int nstr; extern int yyprevious;
#ifdef __cplusplus
/* to avoid CC and lint complaining yyfussy not being used ...*/
static int __lex_hack = 0;
if (__lex_hack) goto yyfussy;
#endif
while((nstr = yylook()) >= 0)
yyfussy: switch(nstr){
case 0:
if(yywrap()) return(0); break;
case 1:

# line 40 "lex.l"
				;
break;
case 2:

# line 42 "lex.l"
	return(DFF)		;
break;
case 3:

# line 43 "lex.l"
	return(DFF)		;
break;
case 4:

# line 44 "lex.l"
	return(NOT)		;
break;
case 5:

# line 45 "lex.l"
	return(NOT)		;
break;
case 6:

# line 46 "lex.l"
	return(NOR)		;
break;
case 7:

# line 47 "lex.l"
	return(NOR)		;
break;
case 8:

# line 48 "lex.l"
	return(NAND)		;
break;
case 9:

# line 49 "lex.l"
	return(NAND)		;
break;
case 10:

# line 50 "lex.l"
	return(AND)		;
break;
case 11:

# line 51 "lex.l"
	return(AND)		;
break;
case 12:

# line 52 "lex.l"
	return(OR)		;
break;
case 13:

# line 53 "lex.l"
	return(OR)		;
break;
case 14:

# line 54 "lex.l"
	return(INPUT)		;
break;
case 15:

# line 55 "lex.l"
	return(INPUT)		;
break;
case 16:

# line 56 "lex.l"
return OUTPUT		;
break;
case 17:

# line 57 "lex.l"
	return(OUTPUT)	;
break;
case 18:

# line 58 "lex.l"
 	 {strcpy(lastconn, yytext) ;return(CONN);}
break;
case 19:

# line 59 "lex.l"
      {init_delay = atof(&yytext[1])	;return(IDEL);}
break;
case 20:

# line 62 "lex.l"
	return(NEWLINE)		;
break;
case 21:

# line 64 "lex.l"
				;
break;
case 22:

# line 65 "lex.l"
	return yytext[0]	;
break;
case -1:
break;
default:
(void)fprintf(yyout,"bad switch yylook %d",nstr);
} return(0); }
/* end of yylex */

int yyvstop[] = {
0,

22,
0,

21,
22,
0,

20,
0,

18,
22,
0,

1,
22,
0,

22,
0,

18,
22,
0,

18,
22,
0,

18,
22,
0,

18,
22,
0,

18,
22,
0,

18,
22,
0,

18,
22,
0,

18,
22,
0,

18,
22,
0,

18,
22,
0,

18,
0,

1,
0,

1,
0,

19,
0,

18,
0,

18,
0,

18,
0,

18,
0,

18,
0,

12,
18,
0,

18,
0,

18,
0,

18,
0,

18,
0,

18,
0,

18,
0,

13,
18,
0,

18,
0,

10,
18,
0,

2,
18,
0,

18,
0,

18,
0,

6,
18,
0,

4,
18,
0,

18,
0,

11,
18,
0,

3,
18,
0,

18,
0,

18,
0,

7,
18,
0,

5,
18,
0,

18,
0,

18,
0,

8,
18,
0,

18,
0,

18,
0,

9,
18,
0,

18,
0,

14,
18,
0,

18,
0,

15,
18,
0,

18,
0,

16,
18,
0,

17,
18,
0,
0};
# define YYTYPE unsigned char
struct yywork { YYTYPE verify, advance; } yycrank[] = {
0,0,	0,0,	1,3,	0,0,	
0,0,	0,0,	0,0,	7,20,	
0,0,	0,0,	1,4,	1,5,	
5,5,	21,21,	0,0,	7,20,	
7,21,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
1,6,	0,0,	0,0,	0,0,	
0,0,	7,20,	0,0,	1,7,	
0,0,	2,7,	0,0,	1,6,	
0,0,	0,0,	0,0,	8,22,	
7,20,	8,22,	8,22,	8,22,	
8,22,	8,22,	8,22,	8,22,	
8,22,	8,22,	8,22,	0,0,	
0,0,	1,8,	1,9,	0,0,	
2,9,	1,10,	7,20,	2,10,	
10,24,	12,26,	1,11,	23,37,	
2,11,	24,38,	40,52,	1,12,	
1,13,	2,12,	2,13,	9,23,	
11,25,	13,28,	25,39,	12,27,	
13,29,	26,40,	27,41,	29,43,	
27,42,	39,51,	43,53,	51,57,	
53,58,	58,61,	1,14,	0,0,	
2,14,	1,15,	30,44,	2,15,	
6,19,	6,19,	1,16,	15,31,	
2,16,	6,19,	6,19,	1,17,	
1,18,	2,17,	2,18,	6,19,	
6,19,	6,19,	6,19,	6,19,	
6,19,	6,19,	6,19,	6,19,	
6,19,	6,19,	6,19,	6,19,	
14,30,	16,32,	18,35,	31,45,	
32,46,	18,36,	6,19,	6,19,	
6,19,	6,19,	6,19,	6,19,	
6,19,	6,19,	6,19,	6,19,	
6,19,	6,19,	6,19,	6,19,	
6,19,	6,19,	6,19,	6,19,	
6,19,	6,19,	6,19,	6,19,	
6,19,	6,19,	6,19,	6,19,	
33,47,	34,48,	36,50,	34,49,	
6,19,	46,54,	6,19,	6,19,	
6,19,	6,19,	6,19,	6,19,	
6,19,	6,19,	6,19,	6,19,	
6,19,	6,19,	6,19,	6,19,	
6,19,	6,19,	6,19,	6,19,	
6,19,	6,19,	6,19,	6,19,	
6,19,	6,19,	6,19,	6,19,	
17,33,	47,55,	50,56,	54,59,	
56,60,	60,62,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	17,34,	0,0,	
0,0};
struct yysvf yysvec[] = {
0,	0,	0,
yycrank+-1,	0,		0,	
yycrank+-3,	yysvec+1,	0,	
yycrank+0,	0,		yyvstop+1,
yycrank+0,	0,		yyvstop+3,
yycrank+2,	0,		yyvstop+6,
yycrank+69,	0,		yyvstop+8,
yycrank+-6,	0,		yyvstop+11,
yycrank+5,	0,		yyvstop+14,
yycrank+5,	yysvec+6,	yyvstop+16,
yycrank+2,	yysvec+6,	yyvstop+19,
yycrank+6,	yysvec+6,	yyvstop+22,
yycrank+8,	yysvec+6,	yyvstop+25,
yycrank+3,	yysvec+6,	yyvstop+28,
yycrank+18,	yysvec+6,	yyvstop+31,
yycrank+5,	yysvec+6,	yyvstop+34,
yycrank+19,	yysvec+6,	yyvstop+37,
yycrank+95,	yysvec+6,	yyvstop+40,
yycrank+16,	yysvec+6,	yyvstop+43,
yycrank+0,	yysvec+6,	yyvstop+46,
yycrank+0,	yysvec+7,	yyvstop+48,
yycrank+3,	0,		yyvstop+50,
yycrank+0,	yysvec+8,	yyvstop+52,
yycrank+7,	yysvec+6,	yyvstop+54,
yycrank+7,	yysvec+6,	yyvstop+56,
yycrank+6,	yysvec+6,	yyvstop+58,
yycrank+11,	yysvec+6,	yyvstop+60,
yycrank+8,	yysvec+6,	yyvstop+62,
yycrank+0,	yysvec+6,	yyvstop+64,
yycrank+7,	yysvec+6,	yyvstop+67,
yycrank+2,	yysvec+6,	yyvstop+69,
yycrank+29,	yysvec+6,	yyvstop+71,
yycrank+20,	yysvec+6,	yyvstop+73,
yycrank+50,	yysvec+6,	yyvstop+75,
yycrank+47,	yysvec+6,	yyvstop+77,
yycrank+0,	yysvec+6,	yyvstop+79,
yycrank+46,	yysvec+6,	yyvstop+82,
yycrank+0,	yysvec+6,	yyvstop+84,
yycrank+0,	yysvec+6,	yyvstop+87,
yycrank+8,	yysvec+6,	yyvstop+90,
yycrank+10,	yysvec+6,	yyvstop+92,
yycrank+0,	yysvec+6,	yyvstop+94,
yycrank+0,	yysvec+6,	yyvstop+97,
yycrank+14,	yysvec+6,	yyvstop+100,
yycrank+0,	yysvec+6,	yyvstop+102,
yycrank+0,	yysvec+6,	yyvstop+105,
yycrank+48,	yysvec+6,	yyvstop+108,
yycrank+93,	yysvec+6,	yyvstop+110,
yycrank+0,	yysvec+6,	yyvstop+112,
yycrank+0,	yysvec+6,	yyvstop+115,
yycrank+82,	yysvec+6,	yyvstop+118,
yycrank+11,	yysvec+6,	yyvstop+120,
yycrank+0,	yysvec+6,	yyvstop+122,
yycrank+11,	yysvec+6,	yyvstop+125,
yycrank+79,	yysvec+6,	yyvstop+127,
yycrank+0,	yysvec+6,	yyvstop+129,
yycrank+79,	yysvec+6,	yyvstop+132,
yycrank+0,	yysvec+6,	yyvstop+134,
yycrank+13,	yysvec+6,	yyvstop+137,
yycrank+0,	yysvec+6,	yyvstop+139,
yycrank+81,	yysvec+6,	yyvstop+142,
yycrank+0,	yysvec+6,	yyvstop+144,
yycrank+0,	yysvec+6,	yyvstop+147,
0,	0,	0};
struct yywork *yytop = yycrank+206;
struct yysvf *yybgin = yysvec+1;
char yymatch[] = {
  0,   1,   1,   1,   1,   1,   1,   1, 
  1,   9,  10,   1,   1,   1,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
  9,   1,   1,  35,  35,   1,   1,   1, 
 35,  35,   1,   1,   1,   1,  46,  35, 
 46,  46,  46,  46,  46,  46,  46,  46, 
 46,  46,  35,   1,   1,   1,   1,   1, 
 64,  35,  35,  35,  35,  35,  35,  35, 
 35,  35,  35,  35,  35,  35,  35,  35, 
 35,  35,  35,  35,  35,  35,  35,  35, 
 35,  35,  35,   1,   1,   1,   1,  35, 
  1,  35,  35,  35,  35,  35,  35,  35, 
 35,  35,  35,  35,  35,  35,  35,  35, 
 35,  35,  35,  35,  35,  35,  35,  35, 
 35,  35,  35,   1,   1,   1,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
  1,   1,   1,   1,   1,   1,   1,   1, 
0};
char yyextra[] = {
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0};
/*	Copyright (c) 1989 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#pragma ident	"@(#)ncform	6.8	95/02/11 SMI"

int yylineno =1;
# define YYU(x) x
# define NLSTATE yyprevious=YYNEWLINE
struct yysvf *yylstate [YYLMAX], **yylsp, **yyolsp;
char yysbuf[YYLMAX];
char *yysptr = yysbuf;
int *yyfnd;
extern struct yysvf *yyestate;
int yyprevious = YYNEWLINE;
#if defined(__cplusplus) || defined(__STDC__)
int yylook(void)
#else
yylook()
#endif
{
	register struct yysvf *yystate, **lsp;
	register struct yywork *yyt;
	struct yysvf *yyz;
	int yych, yyfirst;
	struct yywork *yyr;
# ifdef LEXDEBUG
	int debug;
# endif
	char *yylastch;
	/* start off machines */
# ifdef LEXDEBUG
	debug = 0;
# endif
	yyfirst=1;
	if (!yymorfg)
		yylastch = yytext;
	else {
		yymorfg=0;
		yylastch = yytext+yyleng;
		}
	for(;;){
		lsp = yylstate;
		yyestate = yystate = yybgin;
		if (yyprevious==YYNEWLINE) yystate++;
		for (;;){
# ifdef LEXDEBUG
			if(debug)fprintf(yyout,"state %d\n",yystate-yysvec-1);
# endif
			yyt = yystate->yystoff;
			if(yyt == yycrank && !yyfirst){  /* may not be any transitions */
				yyz = yystate->yyother;
				if(yyz == 0)break;
				if(yyz->yystoff == yycrank)break;
				}
#ifndef __cplusplus
			*yylastch++ = yych = input();
#else
			*yylastch++ = yych = lex_input();
#endif
			if(yylastch > &yytext[YYLMAX]) {
				fprintf(yyout,"Input string too long, limit %d\n",YYLMAX);
				exit(1);
			}
			yyfirst=0;
		tryagain:
# ifdef LEXDEBUG
			if(debug){
				fprintf(yyout,"char ");
				allprint(yych);
				putchar('\n');
				}
# endif
			yyr = yyt;
			if ( (int)yyt > (int)yycrank){
				yyt = yyr + yych;
				if (yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transitions */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					if(lsp > &yylstate[YYLMAX]) {
						fprintf(yyout,"Input string too long, limit %d\n",YYLMAX);
						exit(1);
					}
					goto contin;
					}
				}
# ifdef YYOPTIM
			else if((int)yyt < (int)yycrank) {		/* r < yycrank */
				yyt = yyr = yycrank+(yycrank-yyt);
# ifdef LEXDEBUG
				if(debug)fprintf(yyout,"compressed state\n");
# endif
				yyt = yyt + yych;
				if(yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transitions */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					if(lsp > &yylstate[YYLMAX]) {
						fprintf(yyout,"Input string too long, limit %d\n",YYLMAX);
						exit(1);
					}
					goto contin;
					}
				yyt = yyr + YYU(yymatch[yych]);
# ifdef LEXDEBUG
				if(debug){
					fprintf(yyout,"try fall back character ");
					allprint(YYU(yymatch[yych]));
					putchar('\n');
					}
# endif
				if(yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transition */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					if(lsp > &yylstate[YYLMAX]) {
						fprintf(yyout,"Input string too long, limit %d\n",YYLMAX);
						exit(1);
					}
					goto contin;
					}
				}
			if ((yystate = yystate->yyother) && (yyt= yystate->yystoff) != yycrank){
# ifdef LEXDEBUG
				if(debug)fprintf(yyout,"fall back to state %d\n",yystate-yysvec-1);
# endif
				goto tryagain;
				}
# endif
			else
				{unput(*--yylastch);break;}
		contin:
# ifdef LEXDEBUG
			if(debug){
				fprintf(yyout,"state %d char ",yystate-yysvec-1);
				allprint(yych);
				putchar('\n');
				}
# endif
			;
			}
# ifdef LEXDEBUG
		if(debug){
			fprintf(yyout,"stopped at %d with ",*(lsp-1)-yysvec-1);
			allprint(yych);
			putchar('\n');
			}
# endif
		while (lsp-- > yylstate){
			*yylastch-- = 0;
			if (*lsp != 0 && (yyfnd= (*lsp)->yystops) && *yyfnd > 0){
				yyolsp = lsp;
				if(yyextra[*yyfnd]){		/* must backup */
					while(yyback((*lsp)->yystops,-*yyfnd) != 1 && lsp > yylstate){
						lsp--;
						unput(*yylastch--);
						}
					}
				yyprevious = YYU(*yylastch);
				yylsp = lsp;
				yyleng = yylastch-yytext+1;
				yytext[yyleng] = 0;
# ifdef LEXDEBUG
				if(debug){
					fprintf(yyout,"\nmatch ");
					sprint(yytext);
					fprintf(yyout," action %d\n",*yyfnd);
					}
# endif
				return(*yyfnd++);
				}
			unput(*yylastch);
			}
		if (yytext[0] == 0  /* && feof(yyin) */)
			{
			yysptr=yysbuf;
			return(0);
			}
#ifndef __cplusplus
		yyprevious = yytext[0] = input();
		if (yyprevious>0)
			output(yyprevious);
#else
		yyprevious = yytext[0] = lex_input();
		if (yyprevious>0)
			lex_output(yyprevious);
#endif
		yylastch=yytext;
# ifdef LEXDEBUG
		if(debug)putchar('\n');
# endif
		}
	}
#if defined(__cplusplus) || defined(__STDC__)
int yyback(int *p, int m)
#else
yyback(p, m)
	int *p;
#endif
{
	if (p==0) return(0);
	while (*p) {
		if (*p++ == m)
			return(1);
	}
	return(0);
}
	/* the following are only used in the lex library */
#if defined(__cplusplus) || defined(__STDC__)
int yyinput(void)
#else
yyinput()
#endif
{
#ifndef __cplusplus
	return(input());
#else
	return(lex_input());
#endif
	}
#if defined(__cplusplus) || defined(__STDC__)
void yyoutput(int c)
#else
yyoutput(c)
  int c; 
#endif
{
#ifndef __cplusplus
	output(c);
#else
	lex_output(c);
#endif
	}
#if defined(__cplusplus) || defined(__STDC__)
void yyunput(int c)
#else
yyunput(c)
   int c; 
#endif
{
	unput(c);
	}
