/*******************************************************************
*  MINARET (for edge-triggered circuits)
*
*  BY
*
*  NARESH MAHESHWARI AND SACHIN S. SAPATNEKAR
*
*  Copyright 1998 Iowa State University Research Foundation, Inc.
*  All Rights Reserved
*
*  Source Code for retiming edge-triggered circuits
*
*  ASTRA:   Refer to paper in DAC 95 by Deokar & Sapatnekar
*                       and IEEE Tran on CAD 10/1998
*  Minaret: Refer to paper in DAC 97 by Maheshwari & Sapatnekar
*                       and IEEE Tran on VLSI 10/1998
*
*  Contact Address: sachin@ece.umn.edu
*
*        Availiable on as is basis, with no support
*******************************************************************/
/*******************************
FILE pert.c
all inpust to all outputs pert (refer to Sapatnekar's paper in ISCAS 96)
initially needed for constraint graph generation in Phase A
******************************/

#include "include.h"

/*******************************
GLOBAL VARS
******************************/


extern int db_pert;
extern int db_delay;

Q *levellist[MAX_LEVELS]; /* store gates at their levels */

/* declared global as are initilized once 
   and used in  process_input many times */


float maxeff=-INF;
float eff;
int maxeff_in,maxeff_out;
float inskew,outskew,inoutdel;

/**************************************
find_levels
does a pert to find levelevlize all gates
Primary inputs & latches have level 0
   ***********************************/
void find_levels()
{
  int lno,n,n1;
  Q   *q1;
  W   *w1;
  NODETYPE *np, *np1;

  maxlevel =0; 	/* max level in whole ckt */

  top = bot = NULL;

  maxlevel = 0;

  /* put all inputs and latches in queue */
	
  for(lno=0;lno<nopin;lno++)
    { 
      n = primary_input[lno];
      np = nodes[n];
      np->level = 0;
      addq(n);
    }


  for(q1=latches;q1 != NULL;q1 = q1->next)
    { 
      n = q1->el;
      np = nodes[n];
      np->level = 0;
      addq(n);
    }

	
  /* process whole Queue */
  while(top != NULL)
    {
      /* n,np node on top of Q */
      n = top->el;
      np = nodes[n];
      for(w1 = np->fout; w1 != NULL; w1= w1->next)
	{ /* process fanouts of current node n */
	  n1 = w1->el;
	  np1 = nodes[n1];

	  if(np1->type != Latch) /* if fanout is latch do nothing else */
	    {
	      if( np1->level < (np->level +1) )
		{ 
		  np1->level = np->level + 1 ;
		  if(np1->level > maxlevel)maxlevel = np1->level;
		}

	      if(++np1->nai == np1->nofin)addq(n1);
	      /* all inputs active so add to Q */
	    }
	}
      np->nai = 0; /* reset nai to 0 */
      removeq();
    }/* while Q not empty */
	

}

/**********************************************
 all_pert()

  the all input to all output pert routine
  also  uses graph.c for generating the phase A s-graph;
   calls process_inputs for each input to be processed
************************************************/

void all_pert()
{
  int i,n;
  Q *q1;

  Maxdel= -INF; 	/* max delay over all ckt*/
  Mindel = INF;
  maxeff = -INF;

  for(i=0;i<nogates;i++){
    nodes[gates[i]]->nai =0;
    nodes[gates[i]]->maxti =-INF;
    nodes[gates[i]]->level =-INF;
  }

  find_levels();	/* get leveling done */
#ifdef CHECK
  check_levels();
#endif
  init_graph();		/* get ready for making constraint graph */

  for(i=0;i<MAX_LEVELS;i++)levellist[i]= NULL;/* init */

  for(i =0;i<nopin;i++)
    { /* for all pins i.e.inputs */
      n = primary_input[i];
      process_input(n);
    }
  for(q1=latches;q1 != NULL;q1 = q1->next)
    { /* for all latches i.e.inputs */
      n = q1->el;
      nodes[n]->nai = 0;
      nodes[n]->maxti = 0;				
      process_input(n);

    }
#ifdef DEBUG
  if(db_pert)printf("\nAt END of PERT MIN del %g  MAX del %g\n",Mindel,Maxdel);
  if(db_pert)printf(" max eff from [%d]%s to [%d]%s is  %g IN S %g out %g del %g\n",maxeff_in,nodes[maxeff_in]->name,maxeff_out,nodes[maxeff_out]->name,maxeff,inskew,outskew,inoutdel);
#endif
  complete_graph();


}

/**************************************
 process_input(int in_no)
  
   calculates all input to op delays (min & max)
   required gates to be levellized before hand 
   need initial initilization
   delay propogation is stopped at output /latch
   tries to reinitilize delays as soon as possible
   ***********************************/

void process_input(int in_no)
{


  int n1,cl,cn; /* cn current node, 
		   in_no  current inp beeing processed
		   cl current level
		   n node
		   n1 fanout node*/
  NODETYPE *np, *np1;	
  Q *tq;
  W *w1;


  cn = in_no;
  np = nodes[cn];
  np->maxti = 0;
  np->minti = 0;
  cl = 0;
  tq = (Q *)MALLOC(1,sizeof(Q));
  tq->el = cn;
  tq->next = NULL;
  levellist[0] = tq;

  while(cn != -1)
    {
      /* while gates to be done */
      np = nodes[cn];
#ifdef DEBUG
      if(db_pert)printf(" cn %s\n",nodes[cn]->name);
#endif
      /* set output delays */
      np->maxto = np->maxti + np->maxdel;
      /* process fanouts */
      for(w1 = np->fout; w1 != NULL; w1= w1->next)
	{
	  n1 = w1->el;
	  np1 = nodes[n1];
#ifdef DEBUG
	  if(db_pert)printf(" fanout %s cl %d\n",nodes[n1]->name,cl);
#endif
	  /* if fanout is latch don't update its delay
	     but enter it in the data structure*/

	  if((np1->type == Latch)||(np1->type == Pout))
	    {
	      add_edge(in_no,n1,np->maxto);
	      eff = np->maxto + nodes[in_no]->skew - np1->skew;
	      if(eff > maxeff){
		maxeff = eff; 
		maxeff_out = n1;
		maxeff_in = in_no;
		inskew = nodes[in_no]->skew;
		outskew= np1->skew;
		inoutdel = np->maxto;
	      }

#ifdef DEBUG
	      if(db_delay)printf(" DELAY from [%d] %s to [%d] %s is %g \t skew %d = %g ; %d = %g effective %g\n",in_no,nodes[in_no]->name,n1,nodes[n1]->name,np->maxto,in_no,nodes[in_no]->skew,n1,nodes[n1]->skew,eff);
#endif
	      if(Maxdel <np->maxto)Maxdel = np->maxto;
	      if(Mindel >np->maxto)Mindel = np->maxto;
				
	    }

	  else /*fanout  not a latch so update min/max del */ 
	    {
	      if(np1->maxti < np->maxto)np1->maxti = np->maxto;
	      if((np1->nai) !=10)
		{ /* add to ll only if not there */
		  tq = (Q *)MALLOC(1,sizeof(Q));
		  tq->el = n1;
		  tq->next = levellist[np1->level];
		  levellist[np1->level] = tq;
		  np1->nai = 10; /* mark as in level list */
		}
	    }
	}
      if(db_pert)printf(" fanouts of %s done \n",nodes[cn]->name);
      /* initilize the gate done just now to save init in next input */
      np->maxti = -INF;
      np->maxto = -INF;
      np->nai = 0;

      /*#*#*#*#*#*#*#*#**#*#**#*#*#**#*#*#*#*#*
	CAUTION!!!!!!
	potential problem; removes first node from list
	assuming it to be current node cn
	which is true currently since no additions can take place
	at level "cl" by processing fouts 
	*#*#*#*#*#*#*#*#**#*#**#*#*#**#*#*#*#*#*****/

      tq = levellist[cl];
      levellist[cl] = tq->next;
      free(tq);
      tq = levellist[cl];
      while((tq == NULL)&&(cl <= maxlevel))
	{
	  cl++;
	  tq = levellist[cl];
	}/* find next non empty level */
      if(cl > maxlevel)cn = -1;
      else {
	cn = levellist[cl]->el;
      }
    } /* while */


}

/******************EOF**************/
