/*******************************************************************
*  MINARET (for edge-triggered circuits)
*
*  BY
*
*  NARESH MAHESHWARI AND SACHIN S. SAPATNEKAR
*
*  Copyright 1998 Iowa State University Research Foundation, Inc.
*  All Rights Reserved
*
*  Source Code for retiming edge-triggered circuits
*
*  ASTRA:   Refer to paper in DAC 95 by Deokar & Sapatnekar
*                       and IEEE Tran on CAD 10/1998
*  Minaret: Refer to paper in DAC 97 by Maheshwari & Sapatnekar
*                       and IEEE Tran on VLSI 10/1998
*
*  Contact Address: sachin@ece.umn.edu
*
*        Availiable on as is basis, with no support
*******************************************************************/
/*******************************
FILE postproc.c
merge latches at fanout as postproceesing;
can be deleted if function add_merged_latches_at_fanout(int in)
in cnvt.c is used.
******************************/

#include "include.h"

/*******************************
GLOBAL VARS
******************************/

extern int db_postproc;

/*******************
tries to combine FFs at fanouts of a gate
********************/
void merge_latches()
{
  Q *q1;
  W *w2;
  int n,i,n1,itemp,new_latch;
  NODETYPE *np, *np1;


  top=bot=NULL;

  for(i=0;i<nogates;i++)
    {
      np = nodes[gates[i]];
      np->nai = 0;
    }

  for(q1=latches;q1 != NULL;q1 = q1->next)
    {
      n = q1->el;
      np = nodes[n];
      np->nai = 0;
    }


  for(i=0;i<nopin;i++)  /* may get multiple latches at PINs */
    {
      n = primary_input[i];
      np = nodes[n];
      np->nai = 0;
    }
  for(q1=latches;q1 != NULL;q1 = q1->next)
    {
      n = q1->el;
      np = nodes[n];
      if(np->nofin != 1)printf(" ERR fanin of latch [%d]%s is %d\n",n,np->name,np->nofin);
      for(w2=np->fin;w2 != NULL;w2 = w2->next)/* for all fanin */
	{
	  n1 = w2->el;
	  np1= nodes[n1];
	  if( np1->nai == 0)np1->nai =1; /* first time visit has 1 ff */
	  else if(np1->nai >0) /* already has atleast 1 ff and is not in q so add to q and mark */
	    {
	      np1->nai = -1;
	      addq(n1);
	    }
	}
    }
  if(db_postproc){
    printf(" the q at POST PROCssing is \n");
    printq();
  }
  while(top !=NULL)
    {
      n = top->el;
      removeq();
      new_latch = merge_latches_at_output_without_skew(n);
      if(new_latch >=0 )addq(new_latch);
      /* if in merging some more node gets more than one latchs at op */
      if(0)printf("Merged FFs at op of node [%d]%s type %s \n",n,nodes[n]->name, Node_Type[nodes[n]->type]);

    }


  /****** CHECK IF ALL LATCHES HAVE BEEN MERGED ****/
  for(i=0;i<nogates;i++)
    {
      np = nodes[gates[i]];
      np->nai = 0;
    }

  for(q1=latches;q1 != NULL;q1 = q1->next) /* Latches can have multiple latches at fanouts */
    {
      n = q1->el;
      np = nodes[n];
      np->nai = 0;
    }

  for(i=0;i<nopin;i++)  /* may get multiple latches at PINs */
    {
      n = primary_input[i];
      np = nodes[n];
      np->nai = 0;
    }

  for(q1=latches;q1 != NULL;q1 = q1->next)
    {
      n = q1->el;
      np = nodes[n];
      if(np->nofin != 1)printf(" ERR fanin of latch [%d]%s is %d\n",n,np->name,np->nofin);
      for(w2=np->fin;w2 != NULL;w2 = w2->next)/* for all fanin */
	{
	  n1 = w2->el;
	  np1= nodes[n1];
	  if( np1->nai == 0)np1->nai =1; /* first time visit has 1 ff */
	  else if(np1->nai >0) /* already has atleast 1 ff and is not in q so add to q and mark */
	    {
	      np1->nai = -1;
	      addq(n1);
	    }
	}
    }
  if(db_postproc){
    printf(" the q at POST PROCssing is \n");
    printq();
  }
  while(top !=NULL)
    {
      n = top->el;
      removeq();
      printf(" UN MERGED FFs at op of node [%d]%s type %s \n",n,nodes[n]->name, Node_Type[nodes[n]->type]);
    }


}

/****************************************** 
Not in use.
process a gate to reduce latches by merging latches at ouput of a gate
for minperiod; takes into account their skew before merging
*********************************************/
int merge_latches_at_output(int n)
{
  struct {
    float skew;
    int no;
    int list[MAX_FANINOUT];
  } flist[MAX_FANINOUT];
  int flist_count;

  W *first, *prev, *w1, *w2;
  int n1,tokeep,n2,found,pos,i,j,numb,nofanouts =0;
  NODETYPE *np, *np1, *tokp, *np2;
  float sk;


  first = NULL;
  flist_count = 0;
  for(i=0;i<MAX_FANINOUT;i++){
    flist[i].no =0;
    flist[i].skew = 0.0;
  }


  np = nodes[n];
  if(db_postproc)printf("fanout at gate [%d] %s= %d\n",n,nodes[n]->name,np->nofout);
  for(w1= np->fout; w1 != NULL; w1= w1->next)
    {
      n1 = w1->el;
      np1 = nodes[n1];
      if(np1->type == Latch)
	{
	  sk = np1->skew;
	  if(db_postproc)printf(" found a latch %d at fout of %d skew %g\n",n1,n,sk);
	  found = 0;
	  for(i=0;i<flist_count;i++)
	    {
	      if( (sk <= (flist[i].skew + MERGE_EPSILION))
		  &&(sk >=(flist[i].skew - MERGE_EPSILION))) /*  skew is within eps */
		{
		  flist[i].list[flist[i].no++] = n1;
		  found = 1;
		  if(db_postproc)printf("placing %d at skew list pos %d\n",n1,i);
		  break; /* go to next fanout *******BREAK ****/
		}
	    }
	  if(!found) /* add to next element */
	    {
	      /* first place then add */
	      if(db_postproc)printf("%d not found in skew list sk %g\n",n1,sk);
	      pos = flist_count++;
	      flist[pos].skew = sk;
	      flist[pos].no = 1;
	      flist[pos].list[0] = n1;
	    }
	}/* if latch */
    }/* for all fouts */

  if(db_postproc)printf( " flist count %d and flist\n",flist_count);
  if(db_postproc)for(i=0;i<flist_count;i++)
    {
      printf(" skew %g no latches %d are ",flist[i].skew,flist[i].no);
      for(j=0;j<flist[i].no;j++)printf(" %d\t",flist[i].list[j]);
      printf("\n");
    }

  for(i=0;i<flist_count;i++)
    {
      numb = flist[i].no;
      if(numb >1) /* latches to be merged */
	{
	  sk = flist[i].skew;
	  first = NULL;
	  tokeep =flist[i].list[0] ;
	  tokp = nodes[tokeep];
	  for(j=1;j<numb;j++) /* for all remaining latches */
	    {
	      /* working on removing latch n1 */
	      n1 = flist[i].list[j];
	      np1 = nodes[n1];
	      nofanouts+= np1->nofout;
	      for(w1= np1->fout;w1 != NULL; w1 = w1->next)
		{
		  n2 = w1->el;
		  np2 = nodes[n2];
		  found = 0;
		  for(w2= np2->fin;w2 != NULL; w2 = w2->next)
		    {
		      if(w2->el == n1){
			found = 1; 
			w2->el = tokeep;
		      }
		    }
		  if(!found)printf("ERR in postproc %d not found in fanin of %d\n",n1,n2);
		  prev = w1;
		}
	      prev->next = first;
	      first = np1->fout;
	      /* mark invalid and put in free node lists */
	      validnode[n1] = 0;
	      np1->fout = NULL; /* did't copy th fanout list so don't want it to be freed */
	      free(np1);
	      change--;
	      nolatches--;
	      nonodes--;
	      latches = delete_Q(latches,n1);
	      np->fout = delete_W(np->fout,n1);
	      np->nofout--;
	    }

	  for(w1= tokp->fout;w1 != NULL; w1 = w1->next)
	    {
	      prev = w1;
	    }
	  prev->next = first; /* attach the fanouts of deleted latches to fanout of latches kept*/
	  tokp->nofout += nofanouts;
	}

    }
  return(0);
}



/*****************************************  
process a gate to reduce latches
by merging without  consideringthe skew 

returns NEGATIVE number if no latch was merged
otherwise it returns the id of the marged latch

The problem is
gate --- L -- L
     |---L--- L

becomes
gate ---L --L
         |--L
so when merging latches at a fanout it has to be checked if the  merged latch has more than 
one fanout with latches, if so then add them to the queue.
**************************************** ***/
int merge_latches_at_output_without_skew(int n)
{

  W *wt, *w1, *w2, *w3, *new_fout=NULL;
  int n1,tokeep,n2,found,no_l_fout=0,new_nf;
  NODETYPE *np, *np1, *tokp, *np2;

  tokeep = -1; /* to identify first latch */

  np = nodes[n];
  no_l_fout =0;
  if(db_postproc)printf("fanout at gate [%d] %s= %d\n",n,nodes[n]->name,np->nofout);
  /** single fanout list is used for looping so don't delete latches from it,
    rather make a fresh copy of fanouts **/
  for(w1= np->fout; w1 != NULL; w1= w1->next)
    {
      n1 = w1->el;
      np1 = nodes[n1];
      if(np1->type == Latch)
	{

	  if(tokeep == -1)
	    {
	      /* first latch found */
	      tokeep = n1;
	      tokp = nodes[tokeep];
	      for(w2=tokp->fout;w2 != NULL; w2 = w2->next)
		{
		  n2 = w2->el;
		  np2 = nodes[n2];
		  if(np2->type == Latch)no_l_fout++;
		}
	      new_fout = (W *)MALLOC(1,sizeof(W));
	      new_fout->el = tokeep;
	      new_fout->next = NULL;
	      new_fout->list = NULL;
	      new_nf=1;

	    }


	  else
	    {
	      /* change fanin of fanouts of tokeep latch */
	      for(w2= np1->fout;w2 != NULL; w2 = w2->next)
		{
		  n2 = w2->el;
		  np2 = nodes[n2];

		  if(np2->type == Latch)no_l_fout++;
		  wt = (W *)MALLOC(1,sizeof(W));
		  wt->el = n2;
		  wt->list = NULL;
		  wt->next = tokp->fout;
		  tokp->fout = wt;
		  tokp->nofout++;

		  found = 0;
		  for(w3= np2->fin;w3 != NULL; w3 = w3->next)
		    {
		      if(w3->el == n1){
			found = 1; 
			w3->el = tokeep;
		      }
		    }
		  if(!found){
		    printf("ERR in postproc %d not found in fanin of %d\n",n1,n2);
		    exit(0);
		  }

		}
				

	      validnode[n1] = 0;	   /* mark invalid  */
	      free_W(np1->fout);
	      free(np1->fin);
	      free(np1);
	      change--;
	      nolatches--;
	      nonodes--;
	      latches = delete_Q(latches,n1);
	    }
	}
      else /* gate at fanout, so add it to new fanout */
	{ 
	  wt = (W *)MALLOC(1,sizeof(W));
	  wt->el = n1;
	  wt->list = NULL;
	  wt->next = new_fout;
	  new_fout = wt;
	  new_nf++;
	}

    } /* all fanouts of n */
  free_W(np->fout);
  np->fout = new_fout;
  np->nofout = new_nf;
  if(no_l_fout > 0)return(tokeep);
  else return(-1);
}

/**************** EOF ************/
