/*******************************************************************
*  MINARET (for edge-triggered circuits)
*
*  BY
*
*  NARESH MAHESHWARI AND SACHIN S. SAPATNEKAR
*
*  Copyright 1998 Iowa State University Research Foundation, Inc.
*  All Rights Reserved
*
*  Source Code for retiming edge-triggered circuits
*
*  ASTRA:   Refer to paper in DAC 95 by Deokar & Sapatnekar
*                       and IEEE Tran on CAD 10/1998
*  Minaret: Refer to paper in DAC 97 by Maheshwari & Sapatnekar
*                       and IEEE Tran on VLSI 10/1998
*
*  Contact Address: sachin@ece.umn.edu
*
*        Availiable on as is basis, with no support
*******************************************************************/
/*******************************
FILE print.c
for various debugging and printing
******************************/

#include "include.h"


/*******************************************
 ***************************************/

void printq()
{
  Q *q1;
  printf(" THE Q [%d -- %d]is  ",top,bot);
  for(q1 = top; q1 != NULL; q1= q1->next)
    printf("%d \t",q1->el);
  printf("\n");
}




/*******************************************
  print_levels
***************************************/

void print_levels()
{
  int i;
  Q *q2;
  printf(" LATCHES\n");
	
  for(q2= latches;q2 != NULL;q2= q2->next)
    printf(" %s L%d \n",nodes[q2->el]->name,nodes[q2->el]->level);
  printf("\n\n GATES\n");
  for(i=0;i<nogates;i++)
    printf(" %s L%d \n",nodes[gates[i]]->name,nodes[gates[i]]->level);
}



/*******************************************
 prints the constraint graph
 ***************************************/
void print_graph()
{
  /* prints the constraint graph */
  int i,n;
  EDGE *ept;
  printf("\n___________\n THE GRAPH HAS %d verts %d edges \n",noverts,noedges);

  for(i=0;i<noverts;i++)
    {
      n = verts[i].nodeid;
      printf("\n Vert[%d]%s Skews %g DELAYs\n",i,nodes[n]->name,verts[i].skew);
      for(ept=verts[i].edges[FORWARD];ept!=NULL;ept= ept->next)
	printf("\t to [%d] %s is D %g WT %g\n",ept->tovert,nodes[verts[ept->tovert].nodeid]->name,ept->delay,
	       ept->weight);
      printf(" REVERSE EDGES \n");
      for(ept=verts[i].edges[REVERSE];ept!=NULL;ept= ept->next)
	printf("\t from [%d] %s is %g WT %g\n",ept->tovert,nodes[verts[ept->tovert].nodeid]->name,ept->delay,
	       ept->weight);
    }
  if(0)for(i=0;i<maxid;i++)printf("nod %d %s vert %d\n",i,nodes[i]->name,node2vert[i]);

}

/*******************************************
 prints the constraint graph of Phase A
 ***************************************/
void print_pos_edges()
{
  /* prints the constraint graph */
  int i,n;
  EDGE *ept;
  printf(" THE GRAPH HAS %d verts %d edges \n",noverts,noedges);

  for(i=0;i<noverts;i++)
    {
      n = verts[i].nodeid;
      printf("\n Vert[%d]  %s DELAYs\n",i,nodes[n]->name);
      for(ept=verts[i].edges[FORWARD];ept!=NULL;ept= ept->next)
	{
	  if(ept->weight >0) printf("\t to [%d] %s is %g \n",ept->tovert,nodes[verts[ept->tovert].nodeid]->name,
				    ept->weight);
	}
    }
  if(0)for(i=0;i<maxid;i++)printf("nod %d %s vert %d\n",i,nodes[i]->name,node2vert[i]);

}

/*******************************************
 print_skews
 ***************************************/

void print_skews()
{
  int i;
  Q *q1;
  printf(" The skews are ____\n");
  for(q1=latches;q1 !=NULL; q1 = q1->next)
    {
      i = q1->el;
      printf("[%d] %s : %g\n",i,nodes[i]->name,nodes[i]->skew);
    }
}


/*******************************************
print_node
 ***************************************/

void print_node(int n)
{
  NODETYPE *np;
  W *w1;

  if(validnode[n])
    {
      np = nodes[n];
      printf("\n %s [%d]%s ",Node_Type[np->type],n,np->name);

      printf(" [V%d L%d S%g Del%g P%d] [U%d L%d F%d] ",validnode[n],np->level,np->skew,np->maxdel,np->phase,np->bounds[UPPER],np->bounds[LOWER],np->IsFixed);

      printf(" M[id%d Is%d L%d U%d X%d Max%d] ",np->Id_m,np->Ism,np->Lm,np->Um,np->Xm,np->Maxm);
      printf("[ FI %g FO %g RI %g Ro %g ]\n ",np->maxti,np->maxto,np->rev_maxti,np->rev_maxto);

      printf("\t  {%d} INPUTS ",np->nofin);
      for(w1= np->fin;w1 != NULL; w1= w1->next)printf("[%d]%s w %d ",w1->el,nodes[w1->el]->name,w1->wt);

      printf(" {%d} OUTPUTS ",np->nofout);
      for(w1= np->fout;w1 != NULL; w1= w1->next)printf("[%d]%s w %d ",w1->el,nodes[w1->el]->name,w1->wt);
      printf("\n ");


    }
}

/******************************************
print the circuit
*********************************************/
void print_ckt()
{
  int i;
  NODETYPE  *np;
  W *w1;
	
  printf("\n The circuit is .... \n");
  printf(" Nodes %d gates %d latches %d Pin %d Pout %d\n MAxid %d change %d \n",
	 nonodes,nogates,nolatches,nopin,nopout,maxid,change);

  printf(" P INPUTS \n");
  for(i=0;i<nopin;i++)
    {
      np = nodes[primary_input[i]];
      printf(" [%d]%s P%d %dINS  %d OUTS ",primary_input[i],np->name,np->phase,np->nofin,np->nofout);
      for(w1 = np->fout;w1 != NULL;w1 = w1->next)
	{
	  printf("[%d]%s w%d  ",w1->el,nodes[w1->el]->name,w1->wt);
	}
      printf("\n");
    }

  printf("\n P OUTPUTS \n");
  for(i=0;i<nopout;i++)
    {
      np = nodes[primary_output[i]];
      printf(" [%d]%s P%d L%d  %d OUT %d IN ",primary_output[i],np->name,np->phase,np->level,np->nofout,np->nofin);
      for(w1 = np->fin;w1 != NULL;w1 = w1->next)
	{
	  printf("[%d]%s w%d  ",w1->el,nodes[w1->el]->name,w1->wt);
	}
      printf("\n");
    }
  printf("\n");

  print_latches();

  printf("\n GATES \n ");
  for(i=0;i<nogates;i++)print_node(gates[i]);

  printf("\n END CKT\n");
}


/*******************************************
print_freenodes
 ***************************************/

void print_freenodes()
{
  int i;
  printf("MAXID %d: %d FREE NODES  :",maxid,nofreenodes);
  for(i = 1; i<=nofreenodes;i++)
    printf("%d \t ",freenodes[i]);
  printf("\n");
}


/*******************************************
 print_validnodes
 ***************************************/

void print_validnodes()
{
  int i;
  printf(" VALID NODES ");
  for(i = 0; i<maxid;i++)printf("[%d]%d  ",i,validnode[i]);
  printf("\n");
}


/****************************************
 print_latches
*******************************/
void print_latches()
{
  NODETYPE *np1;
  Q *q2;
  W *w1;
  int t1;



  for(q2= latches;q2 != NULL;q2= q2->next)
    {
      t1 = q2->el;
      if(validnode[t1])
	{
	  np1 = nodes[t1];
	  printf(" DFF  [%d]%s, Skew %g Oth %g D%g FI %g FO %g RI %g Ro %g %d INPUTS ",t1,nodes[t1]->name,np1->skew,np1->other_skew,np1->maxdel,np1->maxti,np1->maxto,np1->rev_maxti,np1->rev_maxto,np1->nofin);
			
	  for(w1 = np1->fin;w1 != NULL; w1 = w1->next)printf("[%d] %s ",w1->el,nodes[w1->el]->name);

	  w1 = np1->fout;
	  printf(" %d OUTPUTS ",np1->nofout);
	  while(w1 != NULL)
	    {
	      printf("[%d] %s ",w1->el,nodes[w1->el]->name);

	      w1 = w1->next;
	    }
	  printf("\n");
	}

    }
}


/******************************************
print_ckt_graph (the C-graph with latches as edge weight)
*****************************************/
void print_ckt_graph()
{
  W *w1;
  F *f1;
  NODETYPE  *np;
  int arc,n,i;

  arc =1;
  printf(" arc #  from   to    wt \n");
  /*for(i=0;i<nopin;i++)
    { np =nodes[primary_input[i]];
    for(w1=np->fout;w1 != NULL; w1= w1->next)
    {
    if(nodes[w1->el]->type == Pout)to = 0;
    else to = w1->el;
    printf(" %d  %d  [%d]%s  %d  \n",arc++,0,to,nodes[to]->name,w1->wt);
	   
    }
    }
    */
  for(i=0;i<nogates;i++)
    { 
      n=gates[i];
      np =nodes[n];
      printf(" Gate [%d]%s [U%d L%d F%d] has  \n",n,np->name,np->bounds[UPPER],np->bounds[LOWER],np->IsFixed);
      printf("\t  {%d} Fanin ",np->nofin);
      for(w1=np->fin;w1 != NULL; w1= w1->next)
	{
	  printf("[%d]%s wt %d list ",w1->el,nodes[w1->el]->name,w1->wt);
	  for(f1= w1->list;f1 != NULL; f1= f1->next)printf("%.1f ",f1->val);
	}
      printf(" \n");
      printf("\t  {%d} Fanout ",np->nofout);
      for(w1=np->fout;w1 != NULL; w1= w1->next)
	{
	  printf("[%d]%s wt %d list ",w1->el,nodes[w1->el]->name,w1->wt);
	  for(f1= w1->list;f1 != NULL; f1= f1->next)printf("%.1f ",f1->val);
	}
      printf(" \n");
      printf(" \n");
    }

  printf(" no arc %d no gates %d + 1 pio\n",arc-1,nogates);

}

/********************************************
print_modified_graph(int mode)
The C-graph with skews
*******************************************/

void print_modified_graph(int mode)
{
  W *w1;
  NODETYPE  *np;
  int arc,n,i;

  arc =1;
  printf(" arc #  from   to    wt \n");
  for(i=0;i<nopin;i++)
    {
      n = primary_input[i];
      np =nodes[n];
      for(w1=np->fout;w1 != NULL; w1= w1->next)
	{
	  if((w1->wt >0)||mode) printf(" %d  [%d]%s  [%d]%s  %d  \n",arc++,n,np->name,w1->el,nodes[w1->el]->name,w1->wt); 
	}

    }

  /** now print the gates ***/
  for(i=0;i<nogates;i++)
    { 
      n=gates[i];
      np =nodes[n];
      for(w1=np->fout;w1 != NULL; w1= w1->next)
	{ 
	  if((w1->wt >0)||mode)printf(" %d  [%d]%s  [%d]%s  %d  \n",arc++,n,np->name,w1->el,nodes[w1->el]->name,w1->wt); 
	}
    }

  printf(" no arc %d no gates %d + 1 pio\n",arc-1,nogates);

}


/*****************************************
print_reverse_modified_graph(int mode)
print fanout-> to -> fanin
********************************************/

void print_reverse_modified_graph(int mode)
{
  W *w1;
  NODETYPE  *np;
  int arc,n,i;

  arc =1;
  printf(" REVERSE arc #  from   to    wt \n");
  for(i=0;i<nopout;i++)
    {
      n = primary_output[i];
      np =nodes[n];
      for(w1=np->fin;w1 != NULL; w1= w1->next)
	{ 
	  if((w1->wt >0)||mode)printf(" %d  [%d]%s  [%d]%s  %d  \n",arc++,n,np->name,w1->el,nodes[w1->el]->name,w1->wt); 
	}

    }

  /** now print the gates ***/
  for(i=0;i<nogates;i++)
    { 
      n=gates[i];
      np =nodes[n];
      for(w1=np->fin;w1 != NULL; w1= w1->next)
	{
	  if((w1->wt >0)||mode) printf(" %d  [%d]%s  [%d]%s  %d  \n",arc++,n,np->name,w1->el,nodes[w1->el]->name,w1->wt); 
	}
    }

  printf(" no arc %d no gates %d + 1 pio\n",arc-1,nogates);

}


/*********EOF**********/
