/***********************************************************************
*  MINARET (for edge-triggered circuits)
*
*  BY
*
*  NARESH MAHESHWARI AND SACHIN S. SAPATNEKAR
*
*  Copyright 1998 Iowa State University Research Foundation, Inc.
*  All Rights Reserved
*
***********************************************************************/
# line 23 "yacc.y"
#include "include.h" 
#include<string.h>

  /*******************************
    FUNCTIONS IN THIS FILE
    *****************************/


#define ADD_GATE_AT_INPUT  /* use to add a gate (of type ARTIF) at every Primary Input/Output
			      to allow merging of FF's at primary inputs.
			      Can be removed if the whole code is cleaned up  */
/*******************************
  GLOBAL VARS
  ******************************/

extern int db_in;
extern int numbertoken, yyleng, yylineno;
extern char yytext[];
extern int hashnodes;
extern int Leak;
int gtype;
W *cur_fanin, *w2, *w1;
Q  *q1;
int n2,n1,n3,n4,cur_node,nofin;
NODETYPE *np, *np1, *np2;
char newff[50];
extern char lastconn[];/* has the name of current connection in it */
int maxfanout_gate,maxfanin_gate;
int init_val;
double init_delay;		      
# define AND 257
# define NAND 258
# define OR 259
# define NOR 260
# define NOT 261
# define DFF 262
# define INPUT 263
# define OUTPUT 264
# define CONN 265
# define NEWLINE 266
# define IDEL 267

#ifdef __STDC__
#include <stdlib.h>
#include <string.h>
#else
#include <malloc.h>
#include <memory.h>
#endif

#include <values.h>

#ifdef __cplusplus

#ifndef yyerror
	void yyerror(const char *);
#endif

#ifndef yylex
#ifdef __EXTERN_C__
	extern "C" { int yylex(void); }
#else
	int yylex(void);
#endif
#endif
	int yyparse(void);

#endif
#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
extern int yyerrflag;
#ifndef YYSTYPE
#define YYSTYPE int
#endif
YYSTYPE yylval;
YYSTYPE yyval;
typedef int yytabelem;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
#if YYMAXDEPTH > 0
int yy_yys[YYMAXDEPTH], *yys = yy_yys;
YYSTYPE yy_yyv[YYMAXDEPTH], *yyv = yy_yyv;
#else	/* user does initial allocation */
int *yys;
YYSTYPE *yyv;
#endif
static int yymaxdepth = YYMAXDEPTH;
# define YYERRCODE 256

# line 344 "yacc.y"


/*********** to give a better error message with line number and text*/
yyerror( msg)
     char *msg;
{
  printf("ERR YACC <file %s>  %s  in text(in[]) ['%s'] at line %d\n",Ckt_Name,msg,yytext,yylineno);exit(-1);
}

/* to get some stats */
findmax_finout()
{
  int i;
  NODETYPE *npl;
  maxfanin=maxfanout=0;
  for(i=0;i<nonodes;i++)
    {
      npl = nodes[i];
      if(maxfanin < npl->nofin){
	maxfanin = npl->nofin;
	maxfanin_gate = i;
      }
      if(maxfanout < npl->nofout){
	maxfanout = npl->nofout;
	maxfanout_gate = i;
      }
    }

}
yytabelem yyexca[] ={
-1, 1,
	0, -1,
	-2, 0,
-1, 9,
	262, 26,
	267, 17,
	-2, 15,
	};
# define YYNPROD 29
# define YYLAST 48
yytabelem yyact[]={

    28,    21,    20,    10,    11,     9,    29,    37,    35,    34,
    33,    26,    27,    24,    25,    23,    19,    18,    22,    36,
    17,    16,    15,    14,    13,    12,     8,     5,     4,     3,
    31,     7,    30,     6,     2,     1,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,    32 };
yytabelem yypact[]={

-10000000,-10000000,  -260,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
  -248,  -249,-10000000,-10000000,  -264,  -246,  -267,  -256,-10000000,-10000000,
-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,  -246,  -255,
  -257,  -258,-10000000,-10000000,-10000000,-10000000,  -259,-10000000 };
yytabelem yypgo[]={

     0,    35,    34,    33,    32,    31,    30,    29,    28,    27,
    26,    25,    24,    23,    22,    18,    21,    20,    19 };
yytabelem yyr1[]={

     0,     1,     4,     3,     6,     5,     2,     2,     7,     7,
     7,     7,    10,    10,     8,    14,    11,    16,    12,    13,
    13,    15,    15,    15,    15,    15,    17,    18,     9 };
yytabelem yyr2[]={

     0,     3,     1,     8,     1,     8,     4,     0,     2,     2,
     2,     2,     2,     2,     7,     1,     7,     1,     9,     5,
     0,     3,     3,     3,     3,     3,     1,     1,    12 };
yytabelem yychk[]={

-10000000,    -1,    -2,    -7,    -8,    -9,    -3,    -5,   -10,   265,
   263,   264,   -11,   -12,   -13,   -14,   -16,   -17,   265,   265,
   266,   265,   -15,   261,   259,   260,   257,   258,   267,   262,
    -4,    -6,   -15,   265,   266,   266,   -18,   266 };
yytabelem yydef[]={

     7,    -2,     1,     6,     8,     9,    10,    11,    20,    -2,
     0,     0,    12,    13,     0,     0,     0,     0,     2,     4,
    14,    19,    16,    21,    22,    23,    24,    25,     0,     0,
     0,     0,    18,    27,     3,     5,     0,    28 };
typedef struct
#ifdef __cplusplus
	yytoktype
#endif
{ char *t_name; int t_val; } yytoktype;
#ifndef YYDEBUG
#	define YYDEBUG	0	/* don't allow debugging */
#endif

#if YYDEBUG

yytoktype yytoks[] =
{
	"AND",	257,
	"NAND",	258,
	"OR",	259,
	"NOR",	260,
	"NOT",	261,
	"DFF",	262,
	"INPUT",	263,
	"OUTPUT",	264,
	"CONN",	265,
	"NEWLINE",	266,
	"IDEL",	267,
	"-unknown-",	-1	/* ends search */
};

char * yyreds[] =
{
	"-no such reduction-",
	"ckt : CKT_block",
	"inputline : INPUT CONN",
	"inputline : INPUT CONN NEWLINE",
	"outputline : OUTPUT CONN",
	"outputline : OUTPUT CONN NEWLINE",
	"CKT_block : CKT_block CKT_line",
	"CKT_block : /* empty */",
	"CKT_line : gate_line",
	"CKT_line : latch_line",
	"CKT_line : inputline",
	"CKT_line : outputline",
	"g1_p1 : gl_p1_nodel",
	"g1_p1 : gl_p1_del",
	"gate_line : g1_p1 fanin NEWLINE",
	"gl_p1_nodel : CONN",
	"gl_p1_nodel : CONN type",
	"gl_p1_del : CONN",
	"gl_p1_del : CONN IDEL type",
	"fanin : fanin CONN",
	"fanin : /* empty */",
	"type : NOT",
	"type : OR",
	"type : NOR",
	"type : AND",
	"type : NAND",
	"latch_line : CONN",
	"latch_line : CONN DFF CONN",
	"latch_line : CONN DFF CONN NEWLINE",
};
#endif /* YYDEBUG */
# line	1 "/usr/ccs/bin/yaccpar"
/*
 * Copyright (c) 1993 by Sun Microsystems, Inc.
 */

#pragma ident	"@(#)yaccpar	6.12	93/06/07 SMI"

/*
** Skeleton parser driver for yacc output
*/

/*
** yacc user known macros and defines
*/
#define YYERROR		goto yyerrlab
#define YYACCEPT	return(0)
#define YYABORT		return(1)
#define YYBACKUP( newtoken, newvalue )\
{\
	if ( yychar >= 0 || ( yyr2[ yytmp ] >> 1 ) != 1 )\
	{\
		yyerror( "syntax error - cannot backup" );\
		goto yyerrlab;\
	}\
	yychar = newtoken;\
	yystate = *yyps;\
	yylval = newvalue;\
	goto yynewstate;\
}
#define YYRECOVERING()	(!!yyerrflag)
#define YYNEW(type)	malloc(sizeof(type) * yynewmax)
#define YYCOPY(to, from, type) \
	(type *) memcpy(to, (char *) from, yynewmax * sizeof(type))
#define YYENLARGE( from, type) \
	(type *) realloc((char *) from, yynewmax * sizeof(type))
#ifndef YYDEBUG
#	define YYDEBUG	1	/* make debugging available */
#endif

/*
** user known globals
*/
int yydebug;			/* set to 1 to get debugging */

/*
** driver internal defines
*/
#define YYFLAG		(-10000000)

/*
** global variables used by the parser
*/
YYSTYPE *yypv;			/* top of value stack */
int *yyps;			/* top of state stack */

int yystate;			/* current state */
int yytmp;			/* extra var (lasts between blocks) */

int yynerrs;			/* number of errors */
int yyerrflag;			/* error recovery flag */
int yychar;			/* current input token number */



#ifdef YYNMBCHARS
#define YYLEX()		yycvtok(yylex())
/*
** yycvtok - return a token if i is a wchar_t value that exceeds 255.
**	If i<255, i itself is the token.  If i>255 but the neither 
**	of the 30th or 31st bit is on, i is already a token.
*/
#if defined(__STDC__) || defined(__cplusplus)
int yycvtok(int i)
#else
int yycvtok(i) int i;
#endif
{
	int first = 0;
	int last = YYNMBCHARS - 1;
	int mid;
	wchar_t j;

	if(i&0x60000000){/*Must convert to a token. */
		if( yymbchars[last].character < i ){
			return i;/*Giving up*/
		}
		while ((last>=first)&&(first>=0)) {/*Binary search loop*/
			mid = (first+last)/2;
			j = yymbchars[mid].character;
			if( j==i ){/*Found*/ 
				return yymbchars[mid].tvalue;
			}else if( j<i ){
				first = mid + 1;
			}else{
				last = mid -1;
			}
		}
		/*No entry in the table.*/
		return i;/* Giving up.*/
	}else{/* i is already a token. */
		return i;
	}
}
#else/*!YYNMBCHARS*/
#define YYLEX()		yylex()
#endif/*!YYNMBCHARS*/

/*
** yyparse - return 0 if worked, 1 if syntax error not recovered from
*/
#if defined(__STDC__) || defined(__cplusplus)
int yyparse(void)
#else
int yyparse()
#endif
{
	register YYSTYPE *yypvt;	/* top of value stack for $vars */

#if defined(__cplusplus) || defined(lint)
/*
	hacks to please C++ and lint - goto's inside switch should never be
	executed; yypvt is set to 0 to avoid "used before set" warning.
*/
	static int __yaccpar_lint_hack__ = 0;
	switch (__yaccpar_lint_hack__)
	{
		case 1: goto yyerrlab;
		case 2: goto yynewstate;
	}
	yypvt = 0;
#endif

	/*
	** Initialize externals - yyparse may be called more than once
	*/
	yypv = &yyv[-1];
	yyps = &yys[-1];
	yystate = 0;
	yytmp = 0;
	yynerrs = 0;
	yyerrflag = 0;
	yychar = -1;

#if YYMAXDEPTH <= 0
	if (yymaxdepth <= 0)
	{
		if ((yymaxdepth = YYEXPAND(0)) <= 0)
		{
			yyerror("yacc initialization error");
			YYABORT;
		}
	}
#endif

	{
		register YYSTYPE *yy_pv;	/* top of value stack */
		register int *yy_ps;		/* top of state stack */
		register int yy_state;		/* current state */
		register int  yy_n;		/* internal state number info */
	goto yystack;	/* moved from 6 lines above to here to please C++ */

		/*
		** get globals into registers.
		** branch to here only if YYBACKUP was called.
		*/
	yynewstate:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;
		goto yy_newstate;

		/*
		** get globals into registers.
		** either we just started, or we just finished a reduction
		*/
	yystack:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;

		/*
		** top of for (;;) loop while no reductions done
		*/
	yy_stack:
		/*
		** put a state and value onto the stacks
		*/
#if YYDEBUG
		/*
		** if debugging, look up token value in list of value vs.
		** name pairs.  0 and negative (-1) are special values.
		** Note: linear search is used since time is not a real
		** consideration while debugging.
		*/
		if ( yydebug )
		{
			register int yy_i;

			printf( "State %d, token ", yy_state );
			if ( yychar == 0 )
				printf( "end-of-file\n" );
			else if ( yychar < 0 )
				printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ++yy_ps >= &yys[ yymaxdepth ] )	/* room on stack? */
		{
			/*
			** reallocate and recover.  Note that pointers
			** have to be reset, or bad things will happen
			*/
			int yyps_index = (yy_ps - yys);
			int yypv_index = (yy_pv - yyv);
			int yypvt_index = (yypvt - yyv);
			int yynewmax;
#ifdef YYEXPAND
			yynewmax = YYEXPAND(yymaxdepth);
#else
			yynewmax = 2 * yymaxdepth;	/* double table size */
			if (yymaxdepth == YYMAXDEPTH)	/* first time growth */
			{
				char *newyys = (char *)YYNEW(int);
				char *newyyv = (char *)YYNEW(YYSTYPE);
				if (newyys != 0 && newyyv != 0)
				{
					yys = YYCOPY(newyys, yys, int);
					yyv = YYCOPY(newyyv, yyv, YYSTYPE);
				}
				else
					yynewmax = 0;	/* failed */
			}
			else				/* not first time */
			{
				yys = YYENLARGE(yys, int);
				yyv = YYENLARGE(yyv, YYSTYPE);
				if (yys == 0 || yyv == 0)
					yynewmax = 0;	/* failed */
			}
#endif
			if (yynewmax <= yymaxdepth)	/* tables not expanded */
			{
				yyerror( "yacc stack overflow" );
				YYABORT;
			}
			yymaxdepth = yynewmax;

			yy_ps = yys + yyps_index;
			yy_pv = yyv + yypv_index;
			yypvt = yyv + yypvt_index;
		}
		*yy_ps = yy_state;
		*++yy_pv = yyval;

		/*
		** we have a new state - find out what to do
		*/
	yy_newstate:
		if ( ( yy_n = yypact[ yy_state ] ) <= YYFLAG )
			goto yydefault;		/* simple state */
#if YYDEBUG
		/*
		** if debugging, need to mark whether new token grabbed
		*/
		yytmp = yychar < 0;
#endif
		if ( ( yychar < 0 ) && ( ( yychar = YYLEX() ) < 0 ) )
			yychar = 0;		/* reached EOF */
#if YYDEBUG
		if ( yydebug && yytmp )
		{
			register int yy_i;

			printf( "Received token " );
			if ( yychar == 0 )
				printf( "end-of-file\n" );
			else if ( yychar < 0 )
				printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ( ( yy_n += yychar ) < 0 ) || ( yy_n >= YYLAST ) )
			goto yydefault;
		if ( yychk[ yy_n = yyact[ yy_n ] ] == yychar )	/*valid shift*/
		{
			yychar = -1;
			yyval = yylval;
			yy_state = yy_n;
			if ( yyerrflag > 0 )
				yyerrflag--;
			goto yy_stack;
		}

	yydefault:
		if ( ( yy_n = yydef[ yy_state ] ) == -2 )
		{
#if YYDEBUG
			yytmp = yychar < 0;
#endif
			if ( ( yychar < 0 ) && ( ( yychar = YYLEX() ) < 0 ) )
				yychar = 0;		/* reached EOF */
#if YYDEBUG
			if ( yydebug && yytmp )
			{
				register int yy_i;

				printf( "Received token " );
				if ( yychar == 0 )
					printf( "end-of-file\n" );
				else if ( yychar < 0 )
					printf( "-none-\n" );
				else
				{
					for ( yy_i = 0;
						yytoks[yy_i].t_val >= 0;
						yy_i++ )
					{
						if ( yytoks[yy_i].t_val
							== yychar )
						{
							break;
						}
					}
					printf( "%s\n", yytoks[yy_i].t_name );
				}
			}
#endif /* YYDEBUG */
			/*
			** look through exception table
			*/
			{
				register int *yyxi = yyexca;

				while ( ( *yyxi != -1 ) ||
					( yyxi[1] != yy_state ) )
				{
					yyxi += 2;
				}
				while ( ( *(yyxi += 2) >= 0 ) &&
					( *yyxi != yychar ) )
					;
				if ( ( yy_n = yyxi[1] ) < 0 )
					YYACCEPT;
			}
		}

		/*
		** check for syntax error
		*/
		if ( yy_n == 0 )	/* have an error */
		{
			/* no worry about speed here! */
			switch ( yyerrflag )
			{
			case 0:		/* new error */
				yyerror( "syntax error" );
				goto skip_init;
			yyerrlab:
				/*
				** get globals into registers.
				** we have a user generated syntax type error
				*/
				yy_pv = yypv;
				yy_ps = yyps;
				yy_state = yystate;
			skip_init:
				yynerrs++;
				/* FALLTHRU */
			case 1:
			case 2:		/* incompletely recovered error */
					/* try again... */
				yyerrflag = 3;
				/*
				** find state where "error" is a legal
				** shift action
				*/
				while ( yy_ps >= yys )
				{
					yy_n = yypact[ *yy_ps ] + YYERRCODE;
					if ( yy_n >= 0 && yy_n < YYLAST &&
						yychk[yyact[yy_n]] == YYERRCODE)					{
						/*
						** simulate shift of "error"
						*/
						yy_state = yyact[ yy_n ];
						goto yy_stack;
					}
					/*
					** current state has no shift on
					** "error", pop stack
					*/
#if YYDEBUG
#	define _POP_ "Error recovery pops state %d, uncovers state %d\n"
					if ( yydebug )
						printf( _POP_, *yy_ps,
							yy_ps[-1] );
#	undef _POP_
#endif
					yy_ps--;
					yy_pv--;
				}
				/*
				** there is no state on stack with "error" as
				** a valid shift.  give up.
				*/
				YYABORT;
			case 3:		/* no shift yet; eat a token */
#if YYDEBUG
				/*
				** if debugging, look up token in list of
				** pairs.  0 and negative shouldn't occur,
				** but since timing doesn't matter when
				** debugging, it doesn't hurt to leave the
				** tests here.
				*/
				if ( yydebug )
				{
					register int yy_i;

					printf( "Error recovery discards " );
					if ( yychar == 0 )
						printf( "token end-of-file\n" );
					else if ( yychar < 0 )
						printf( "token -none-\n" );
					else
					{
						for ( yy_i = 0;
							yytoks[yy_i].t_val >= 0;
							yy_i++ )
						{
							if ( yytoks[yy_i].t_val
								== yychar )
							{
								break;
							}
						}
						printf( "token %s\n",
							yytoks[yy_i].t_name );
					}
				}
#endif /* YYDEBUG */
				if ( yychar == 0 )	/* reached EOF. quit */
					YYABORT;
				yychar = -1;
				goto yy_newstate;
			}
		}/* end if ( yy_n == 0 ) */
		/*
		** reduction by production yy_n
		** put stack tops, etc. so things right after switch
		*/
#if YYDEBUG
		/*
		** if debugging, print the string that is the user's
		** specification of the reduction which is just about
		** to be done.
		*/
		if ( yydebug )
			printf( "Reduce by (%d) \"%s\"\n",
				yy_n, yyreds[ yy_n ] );
#endif
		yytmp = yy_n;			/* value to switch over */
		yypvt = yy_pv;			/* $vars top of value stack */
		/*
		** Look in goto table for next state
		** Sorry about using yy_state here as temporary
		** register variable, but why not, if it works...
		** If yyr2[ yy_n ] doesn't have the low order bit
		** set, then there is no action to be done for
		** this reduction.  So, no saving & unsaving of
		** registers done.  The only difference between the
		** code just after the if and the body of the if is
		** the goto yy_stack in the body.  This way the test
		** can be made before the choice of what to do is needed.
		*/
		{
			/* length of production doubled with extra bit */
			register int yy_len = yyr2[ yy_n ];

			if ( !( yy_len & 01 ) )
			{
				yy_len >>= 1;
				yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
				yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
					*( yy_ps -= yy_len ) + 1;
				if ( yy_state >= YYLAST ||
					yychk[ yy_state =
					yyact[ yy_state ] ] != -yy_n )
				{
					yy_state = yyact[ yypgo[ yy_n ] ];
				}
				goto yy_stack;
			}
			yy_len >>= 1;
			yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
			yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
				*( yy_ps -= yy_len ) + 1;
			if ( yy_state >= YYLAST ||
				yychk[ yy_state = yyact[ yy_state ] ] != -yy_n )
			{
				yy_state = yyact[ yypgo[ yy_n ] ];
			}
		}
					/* save until reenter driver code */
		yystate = yy_state;
		yyps = yy_ps;
		yypv = yy_pv;
	}
	/*
	** code supplied by user is placed in this switch
	*/
	switch( yytmp )
	{
		
case 1:
# line 61 "yacc.y"
{
  findmax_finout();

  if(0){  /** debug statements, caused 8K memory leak(don't know why)**/ 
    printf(" Circuit read inp %d out %d gates %d latches %d  Made nodes %d\n",nopin,nopout,nogates,nolatches,nonodes);
		       
    printf(" Max fan OUT is %d at [%d]%s ",maxfanout,maxfanout_gate,nodes[maxfanout_gate]->name);
		       
    printf(" Max fan IN is %d at [%d]%s \n",maxfanin,maxfanin_gate,nodes[maxfanin_gate]->name);
  }

  /* this done for debugging so that when printing node 
     corresponding to a vertex by nodes[vert->id] we get
     proper names */
  pin_name = nonodes;
  /*    strcpy(nodes[pin_name]->name,"PIO");*/
  maxid = nonodes;

  /*** destroying hash slows down the program (don't know why but if I free the hash
    table here, then "malloc" and "free" later take much longer)*/
  if(!Leak)destroy_hash();  /* free hash table */
} break;
case 2:
# line 87 "yacc.y"
{
  /* read in a primary input with 0 fanin */
  n2 = searchhash(yytext,0);
#ifdef ADD_GATE_AT_INPUT
  /** ADDING A ZERO DELAY GATE AFTER EVERY PIO ***/
  /* readin extra node for output */
  strcpy(newff,nodes[n2]->name);
  strcat(newff,"_PI");
  n3 = searchhash(newff,0);
  artificial[noart++] = n2;
  primary_input[nopin++] = n3;
  np1 = nodes[n3];
  np1->type = Pin;
		     
		     
		     /* connect n3 to n2 */
  np1->fout = (W *)MALLOC(1,sizeof(W));
  np1->fout->el = n2;
  np1->fout->list = NULL;
  np1->fout->next = NULL;
  np1->nofout = 1;
		     
  /* connect n2 back to n3 */
  np1 = nodes[n2];
  np1->fin = (W *)MALLOC(1,sizeof(W));
  np1->fin->el = n3;
  np1->fin->next = NULL;
  np1->fin->list = NULL;
  np1->nofin = 1;
  np1->maxdel = 0;
  np1->mindel = 0;
  np1->type = ARTIFICIAL;
  gates[nogates++] = n2;
#else
  primary_input[nopin++] = n2;
  np =  nodes[n2];
  np->type = Pin;
	
#endif			
} break;
case 4:
# line 135 "yacc.y"
{
  /* create a primary output with 0 fanout */
  n2 = searchhash(yytext,0);
		    
		    /* readin extra node for output */
		    
  strcpy(newff,nodes[n2]->name);
  strcat(newff,"_PO");
  n3 = searchhash(newff,0);
  primary_output[nopout++] = n3;
  np1 = nodes[n3];
  np1->type = Pout;
  np1->fin = (W *)MALLOC(1,sizeof(W));
  np1->nofin = 1;
  np1->fin->next = NULL;
  np1->fin->list = NULL;
  /* will fill the fanin of PIO node in #ifdef s */
		    
#ifdef ADD_GATE_AT_INPUT
  /** ADDING A ZERO DELAY GATE BEFORE EVERY POUT***/
  /* readin extra node for output */
  strcpy(newff,nodes[n2]->name);
  strcat(newff,"_ART");
  n4 = searchhash(newff,0);
  artificial[noart++] = n4;
  np2 = nodes[n4];
  np2->type = ARTIFICIAL;
  np2->maxdel = 0;
  np2->mindel = 0;
  gates[nogates++] = n4;
		    
  np2->fin = (W *)MALLOC(1,sizeof(W));
  np2->fin->el = n2;
  np2->fin->next = NULL;
  np2->fin->list = NULL;
  np2->nofin = 1;
		    
  np2->fout = (W *)MALLOC(1,sizeof(W));
  np2->fout->el = n3;
  np2->fout->next = NULL;
  np2->fout->list = NULL;
  np2->nofout = 1;
		    
  np1->fin->el = n4;

  w2 = (W *)MALLOC(1,sizeof(W));
  w2->el = n4;
  w2->list = NULL;
  w2->next = nodes[n2]->fout;
  nodes[n2]->fout = w2;
  nodes[n2]->nofout++;
		    
#else
  np1->fin->el = n2;

  w2 = (W *)MALLOC(1,sizeof(W));
  w2->el = n3;
  w2->list = NULL;
  w2->next = nodes[n2]->fout;
  nodes[n2]->fout = w2;
  nodes[n2]->nofout++;
		    
#endif


} break;
case 14:
# line 219 "yacc.y"
{
  np = nodes[n1];
  np->fin = cur_fanin;
  np->nofin = nofin;
  np->type = gtype;
  gates[nogates++] = n1;
  cur_fanin = NULL;
  nofin = 0;
} break;
case 15:
# line 231 "yacc.y"
{
	
  n1 = searchhash(lastconn,0);
} break;
case 16:
# line 237 "yacc.y"
{
  nodes[n1]->maxdel = -1.0;
} break;
case 17:
# line 242 "yacc.y"
{
	
  n1 = searchhash(lastconn,0);
} break;
case 18:
# line 248 "yacc.y"
{
  nodes[n1]->maxdel = (float) init_delay;
} break;
case 19:
# line 257 "yacc.y"
{
  w2 = (W *)MALLOC(1,sizeof(W));
  w2->list = NULL;
  /* add CONN to current fanin list */
  cur_node = searchhash(yytext,0);
  w2->el = cur_node;
  w2->next = cur_fanin;
  cur_fanin = w2;
  nofin++;
  /* update current gates fanout */
  w2 = (W *)MALLOC(1,sizeof(W));
  w2->list = NULL;
  w2->el = n1; /*the gate being processed */
  nodes[cur_node]->nofout++;
  w2->next = nodes[cur_node]->fout;
  nodes[cur_node]->fout = w2;
} break;
case 21:
# line 279 "yacc.y"
{
  gtype = Not;
} break;
case 22:
# line 284 "yacc.y"
{
  gtype = Or;
} break;
case 23:
# line 289 "yacc.y"
{
  gtype = Nor;
} break;
case 24:
# line 294 "yacc.y"
{
  gtype = And;
} break;
case 25:
# line 299 "yacc.y"
{
  gtype = Nand;
} break;
case 26:
# line 306 "yacc.y"
{
  n1 = searchhash(lastconn,0);
		   
} break;
case 27:
# line 312 "yacc.y"
{
	
  np = nodes[n1];
  np->type = Latch;
  np->phase = 1; /*** Not usefull for edge-triggered circuits **/
  np->IsFixed = 0;
  q1 = (Q *)MALLOC(1,sizeof(Q));
  q1->el = n1;
  q1->next = latches;
  latches = q1;
  nolatches++;
  w2 = (W *)MALLOC(1,sizeof(W));
  /* add CONN to current fanin list */
  n2 = searchhash(yytext,0);
  w2->el = n2;
  w2->next = NULL;
  np->nofin = 1;
  np->fin = w2;
  /* update current gates fanout */
  w2 = (W *)MALLOC(1,sizeof(W));
  w2->el = n1; /**/
  w2->list = NULL;
  nodes[n2]->nofout++;
  w2->next = nodes[n2]->fout;
  nodes[n2]->fout = w2;
} break;
# line	532 "/usr/ccs/bin/yaccpar"
	}
	goto yystack;		/* reset registers in driver code */
}

