/*******************************************************************
*  MINARET (for edge-triggered circuits)
*
*  BY
*
*  NARESH MAHESHWARI AND SACHIN S. SAPATNEKAR
*
*  Copyright 1998 Iowa State University Research Foundation, Inc.
*  All Rights Reserved
*
*  Source Code for retiming edge-triggered circuits
*
*  ASTRA:   Refer to paper in DAC 95 by Deokar & Sapatnekar
*                       and IEEE Tran on CAD 10/1998
*  Minaret: Refer to paper in DAC 97 by Maheshwari & Sapatnekar
*                       and IEEE Tran on VLSI 10/1998
*
*  Contact Address: sachin@ece.umn.edu
*
*        Availiable on as is basis, with no support
*******************************************************************/
/*******************************
FILE  yacc.y

Yacc grammer for retiming of edge-triggered circuits, in the 
modified MCNC format

*****************************/
%{
#include "include.h" 
#include<string.h>

  /*******************************
    FUNCTIONS IN THIS FILE
    *****************************/


#define ADD_GATE_AT_INPUT  /* use to add a gate (of type ARTIF) at every Primary Input/Output
			      to allow merging of FF's at primary inputs.
			      Can be removed if the whole code is cleaned up  */
/*******************************
  GLOBAL VARS
  ******************************/

extern int db_in;
extern int numbertoken, yyleng, yylineno;
extern char yytext[];
extern int hashnodes;
extern int Leak;
int gtype;
W *cur_fanin, *w2, *w1;
Q  *q1;
int n2,n1,n3,n4,cur_node,nofin;
NODETYPE *np, *np1, *np2;
char newff[50];
extern char lastconn[];/* has the name of current connection in it */
int maxfanout_gate,maxfanin_gate;
int init_val;
double init_delay;		      
%}


%token  AND,NAND, OR, NOR, NOT, DFF, INPUT, OUTPUT, CONN, NEWLINE, IDEL
%start  ckt
%%
ckt	 	:  CKT_block

{
  findmax_finout();

  if(0){  /** debug statements, caused 8K memory leak(don't know why)**/ 
    printf(" Circuit read inp %d out %d gates %d latches %d  Made nodes %d\n",nopin,nopout,nogates,nolatches,nonodes);
		       
    printf(" Max fan OUT is %d at [%d]%s ",maxfanout,maxfanout_gate,nodes[maxfanout_gate]->name);
		       
    printf(" Max fan IN is %d at [%d]%s \n",maxfanin,maxfanin_gate,nodes[maxfanin_gate]->name);
  }

  /* this done for debugging so that when printing node 
     corresponding to a vertex by nodes[vert->id] we get
     proper names */
  pin_name = nonodes;
  /*    strcpy(nodes[pin_name]->name,"PIO");*/
  maxid = nonodes;

  /*** destroying hash slows down the program (don't know why but if I free the hash
    table here, then "malloc" and "free" later take much longer)*/
  if(!Leak)destroy_hash();  /* free hash table */
};



inputline	: INPUT CONN 
{
  /* read in a primary input with 0 fanin */
  n2 = searchhash(yytext,0);
#ifdef ADD_GATE_AT_INPUT
  /** ADDING A ZERO DELAY GATE AFTER EVERY PIO ***/
  /* readin extra node for output */
  strcpy(newff,nodes[n2]->name);
  strcat(newff,"_PI");
  n3 = searchhash(newff,0);
  artificial[noart++] = n2;
  primary_input[nopin++] = n3;
  np1 = nodes[n3];
  np1->type = Pin;
		     
		     
		     /* connect n3 to n2 */
  np1->fout = (W *)MALLOC(1,sizeof(W));
  np1->fout->el = n2;
  np1->fout->list = NULL;
  np1->fout->next = NULL;
  np1->nofout = 1;
		     
  /* connect n2 back to n3 */
  np1 = nodes[n2];
  np1->fin = (W *)MALLOC(1,sizeof(W));
  np1->fin->el = n3;
  np1->fin->next = NULL;
  np1->fin->list = NULL;
  np1->nofin = 1;
  np1->maxdel = 0;
  np1->mindel = 0;
  np1->type = ARTIFICIAL;
  gates[nogates++] = n2;
#else
  primary_input[nopin++] = n2;
  np =  nodes[n2];
  np->type = Pin;
	
#endif			
}

NEWLINE
;

/*====================================================*/


outputline	: OUTPUT CONN 
{
  /* create a primary output with 0 fanout */
  n2 = searchhash(yytext,0);
		    
		    /* readin extra node for output */
		    
  strcpy(newff,nodes[n2]->name);
  strcat(newff,"_PO");
  n3 = searchhash(newff,0);
  primary_output[nopout++] = n3;
  np1 = nodes[n3];
  np1->type = Pout;
  np1->fin = (W *)MALLOC(1,sizeof(W));
  np1->nofin = 1;
  np1->fin->next = NULL;
  np1->fin->list = NULL;
  /* will fill the fanin of PIO node in #ifdef s */
		    
#ifdef ADD_GATE_AT_INPUT
  /** ADDING A ZERO DELAY GATE BEFORE EVERY POUT***/
  /* readin extra node for output */
  strcpy(newff,nodes[n2]->name);
  strcat(newff,"_ART");
  n4 = searchhash(newff,0);
  artificial[noart++] = n4;
  np2 = nodes[n4];
  np2->type = ARTIFICIAL;
  np2->maxdel = 0;
  np2->mindel = 0;
  gates[nogates++] = n4;
		    
  np2->fin = (W *)MALLOC(1,sizeof(W));
  np2->fin->el = n2;
  np2->fin->next = NULL;
  np2->fin->list = NULL;
  np2->nofin = 1;
		    
  np2->fout = (W *)MALLOC(1,sizeof(W));
  np2->fout->el = n3;
  np2->fout->next = NULL;
  np2->fout->list = NULL;
  np2->nofout = 1;
		    
  np1->fin->el = n4;

  w2 = (W *)MALLOC(1,sizeof(W));
  w2->el = n4;
  w2->list = NULL;
  w2->next = nodes[n2]->fout;
  nodes[n2]->fout = w2;
  nodes[n2]->nofout++;
		    
#else
  np1->fin->el = n2;

  w2 = (W *)MALLOC(1,sizeof(W));
  w2->el = n3;
  w2->list = NULL;
  w2->next = nodes[n2]->fout;
  nodes[n2]->fout = w2;
  nodes[n2]->nofout++;
		    
#endif


}
NEWLINE
;

/*====================================================*/


CKT_block	: CKT_block CKT_line
| 
                ;


CKT_line        : gate_line | latch_line |inputline |outputline
;

g1_p1           : gl_p1_nodel | gl_p1_del
;

gate_line	: g1_p1  fanin NEWLINE
{
  np = nodes[n1];
  np->fin = cur_fanin;
  np->nofin = nofin;
  np->type = gtype;
  gates[nogates++] = n1;
  cur_fanin = NULL;
  nofin = 0;
}
;

gl_p1_nodel	: CONN 
{
	
  n1 = searchhash(lastconn,0);
}

type
{
  nodes[n1]->maxdel = -1.0;
}
;
gl_p1_del	: CONN 
{
	
  n1 = searchhash(lastconn,0);
}

IDEL type
{
  nodes[n1]->maxdel = (float) init_delay;
}
;


fanin          :fanin
CONN 

{
  w2 = (W *)MALLOC(1,sizeof(W));
  w2->list = NULL;
  /* add CONN to current fanin list */
  cur_node = searchhash(yytext,0);
  w2->el = cur_node;
  w2->next = cur_fanin;
  cur_fanin = w2;
  nofin++;
  /* update current gates fanout */
  w2 = (W *)MALLOC(1,sizeof(W));
  w2->list = NULL;
  w2->el = n1; /*the gate being processed */
  nodes[cur_node]->nofout++;
  w2->next = nodes[cur_node]->fout;
  nodes[cur_node]->fout = w2;
}
|
               ;


type    : NOT 
{
  gtype = Not;
} 
|
OR
{
  gtype = Or;
} 
|
NOR
{
  gtype = Nor;
} 
|
AND
{
  gtype = And;
} 
|
NAND
{
  gtype = Nand;
}
;


latch_line	: CONN
{
  n1 = searchhash(lastconn,0);
		   
}

DFF  CONN 
{
	
  np = nodes[n1];
  np->type = Latch;
  np->phase = 1; /*** Not usefull for edge-triggered circuits **/
  np->IsFixed = 0;
  q1 = (Q *)MALLOC(1,sizeof(Q));
  q1->el = n1;
  q1->next = latches;
  latches = q1;
  nolatches++;
  w2 = (W *)MALLOC(1,sizeof(W));
  /* add CONN to current fanin list */
  n2 = searchhash(yytext,0);
  w2->el = n2;
  w2->next = NULL;
  np->nofin = 1;
  np->fin = w2;
  /* update current gates fanout */
  w2 = (W *)MALLOC(1,sizeof(W));
  w2->el = n1; /**/
  w2->list = NULL;
  nodes[n2]->nofout++;
  w2->next = nodes[n2]->fout;
  nodes[n2]->fout = w2;
}

NEWLINE
;
  
 

%%

/*********** to give a better error message with line number and text*/
yyerror( msg)
     char *msg;
{
  printf("ERR YACC <file %s>  %s  in text(in[]) ['%s'] at line %d\n",Ckt_Name,msg,yytext,yylineno);exit(-1);
}

/* to get some stats */
findmax_finout()
{
  int i;
  NODETYPE *npl;
  maxfanin=maxfanout=0;
  for(i=0;i<nonodes;i++)
    {
      npl = nodes[i];
      if(maxfanin < npl->nofin){
	maxfanin = npl->nofin;
	maxfanin_gate = i;
      }
      if(maxfanout < npl->nofout){
	maxfanout = npl->nofout;
	maxfanout_gate = i;
      }
    }

}
